/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.image;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLImageRenderer
implements XHTMLImageRenderer,
Initializable {
    private XHTMLWikiPrinter xhtmlPrinter;
    private WikiModel wikiModel;
    @Inject
    private ComponentManager componentManager;

    @Override
    public void initialize() throws InitializationException {
        try {
            this.wikiModel = this.componentManager.lookup(WikiModel.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        String imageURL;
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (reference.getType().equals(ResourceType.ATTACHMENT) || reference.getType().equals(ResourceType.ICON)) {
            if (this.wikiModel == null) throw new RuntimeException("Invalid Image type. In non wiki mode, all image types must be URL images.");
            imageURL = this.wikiModel.getImageURL(reference, parameters);
        } else {
            imageURL = reference.getReference();
        }
        attributes.put("src", imageURL);
        if (isFreeStandingURI) {
            attributes.put("class", "wikimodel-freestanding");
        }
        attributes.putAll(parameters);
        if (!parameters.containsKey("alt")) {
            attributes.put("alt", this.computeAltAttributeValue(reference));
        }
        this.getXHTMLWikiPrinter().printXMLElement("img", attributes);
    }

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = this.componentManager.lookup(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }
}

