/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.dom4j.xpath;

import java.io.Serializable;
import org.jaxen.NamespaceContext;
import org.xwiki.shaded.dom4j.Document;
import org.xwiki.shaded.dom4j.Element;
import org.xwiki.shaded.dom4j.Namespace;
import org.xwiki.shaded.dom4j.Node;

public class DefaultNamespaceContext
implements NamespaceContext,
Serializable {
    private final Element element;

    public DefaultNamespaceContext(Element element) {
        this.element = element;
    }

    public static DefaultNamespaceContext create(Object node) {
        Element element = null;
        if (node instanceof Element) {
            element = (Element)node;
        } else if (node instanceof Document) {
            Document doc = (Document)node;
            element = doc.getRootElement();
        } else if (node instanceof Node) {
            element = ((Node)node).getParent();
        }
        if (element != null) {
            return new DefaultNamespaceContext(element);
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix) {
        Namespace ns;
        if (prefix != null && prefix.length() > 0 && (ns = this.element.getNamespaceForPrefix(prefix)) != null) {
            return ns.getURI();
        }
        return null;
    }
}

