/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import org.xwiki.shaded.htmlcleaner.BaseToken;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.CommentToken;
import org.xwiki.shaded.htmlcleaner.ContentToken;
import org.xwiki.shaded.htmlcleaner.TagNode;
import org.xwiki.shaded.htmlcleaner.Utils;
import org.xwiki.shaded.htmlcleaner.XmlSerializer;

public class CompactXmlSerializer
extends XmlSerializer {
    public CompactXmlSerializer(CleanerProperties cleanerProperties) {
        super(cleanerProperties);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        List list = tagNode.getChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string;
                Object e = listIterator.next();
                if (e == null) continue;
                if (e instanceof ContentToken) {
                    string = ((ContentToken)e).getContent().trim();
                    writer.write(this.dontEscape(tagNode) ? string.replaceAll("]]>", "]]&gt;") : this.escapeXml(string));
                    if (!listIterator.hasNext()) continue;
                    if (!Utils.isWhitespaceString(listIterator.next())) {
                        writer.write("\n");
                    }
                    listIterator.previous();
                    continue;
                }
                if (e instanceof CommentToken) {
                    string = ((CommentToken)e).getCommentedContent().trim();
                    writer.write(string);
                    continue;
                }
                ((BaseToken)e).serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }
}

