/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.shaded.htmlcleaner.Utils;

public class TagTransformation {
    private String sourceTag;
    private String destTag;
    private boolean preserveSourceAttributes;
    private Map attributeTransformations;

    public TagTransformation(String string, String string2, boolean bl) {
        this.sourceTag = string.toLowerCase();
        this.destTag = string2 == null ? null : (Utils.isValidXmlIdentifier(string2) ? string2.toLowerCase() : string);
        this.preserveSourceAttributes = bl;
    }

    public TagTransformation(String string, String string2) {
        this(string, string2, true);
    }

    public TagTransformation(String string) {
        this(string, null);
    }

    public void addAttributeTransformation(String string, String string2) {
        if (this.attributeTransformations == null) {
            this.attributeTransformations = new LinkedHashMap();
        }
        this.attributeTransformations.put(string.toLowerCase(), string2);
    }

    public void addAttributeTransformation(String string) {
        this.addAttributeTransformation(string, null);
    }

    boolean hasAttributeTransformations() {
        return this.attributeTransformations != null;
    }

    String getSourceTag() {
        return this.sourceTag;
    }

    String getDestTag() {
        return this.destTag;
    }

    boolean isPreserveSourceAttributes() {
        return this.preserveSourceAttributes;
    }

    Map getAttributeTransformations() {
        return this.attributeTransformations;
    }
}

