/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.confluence;

import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.xwiki.shaded.wikimodel.wem.CompositeListener;
import org.xwiki.shaded.wikimodel.wem.IWemListener;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;
import org.xwiki.shaded.wikimodel.wem.WikiParserException;
import org.xwiki.shaded.wikimodel.wem.confluence.ConfluenceWikiParser;

public class ConfluenceExtendedWikiParser
extends ConfluenceWikiParser {
    public void parse(Reader reader, IWemListener listener) throws WikiParserException {
        EnhancedListener composite = new EnhancedListener(listener);
        super.parse(reader, composite);
    }

    public static class EnhancedListener
    extends CompositeListener {
        private Stack<Boolean> fSkipDocument = new Stack();

        public EnhancedListener(IWemListener ... listeners) {
            super(listeners);
        }

        public void beginDocument(WikiParameters params) {
            if (!this.skipDocument()) {
                super.beginDocument(params);
            }
        }

        public void beginSection(int docLevel, int headerLevel, WikiParameters params) {
            if (!this.skipDocument()) {
                super.beginSection(docLevel, headerLevel, params);
            }
        }

        public void beginSectionContent(int docLevel, int headerLevel, WikiParameters params) {
            if (!this.skipDocument()) {
                super.beginSectionContent(docLevel, headerLevel, params);
            }
            this.push(false);
        }

        public void endDocument(WikiParameters params) {
            if (!this.skipDocument()) {
                super.endDocument(params);
            }
        }

        public void endSection(int docLevel, int headerLevel, WikiParameters params) {
            if (!this.skipDocument()) {
                super.endSection(docLevel, headerLevel, params);
            }
        }

        public void endSectionContent(int docLevel, int headerLevel, WikiParameters params) {
            this.pop();
            if (!this.skipDocument()) {
                super.endSectionContent(docLevel, headerLevel, params);
            }
        }

        public void onMacroBlock(String macroName, WikiParameters params, String content) {
            String type = null;
            if ("note".equals(macroName)) {
                type = "N";
            } else if ("tip".equals(macroName)) {
                type = "T";
            }
            if (type != null) {
                this.beginInfoBlock(type, params);
                this.parseContent(content);
                this.endInfoBlock(type, params);
            } else {
                super.onMacroBlock(macroName, params, content);
            }
        }

        private void parseContent(String content) {
            try {
                this.push(true);
                StringReader reader = new StringReader(content);
                ConfluenceWikiParser parser = new ConfluenceWikiParser();
                parser.parse(reader, this);
                this.pop();
            }
            catch (WikiParserException e) {
                throw new RuntimeException(e);
            }
        }

        private void pop() {
            this.fSkipDocument.pop();
        }

        private void push(boolean b) {
            this.fSkipDocument.push(b);
        }

        private boolean skipDocument() {
            if (this.fSkipDocument.isEmpty()) {
                return false;
            }
            Boolean peek = this.fSkipDocument.peek();
            return peek;
        }
    }
}

