/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.shaded.wikimodel.wem.WikiFormat;
import org.xwiki.shaded.wikimodel.wem.WikiParameter;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;
import org.xwiki.shaded.wikimodel.wem.WikiReference;
import org.xwiki.shaded.wikimodel.wem.WikiStyle;
import org.xwiki.shaded.wikimodel.wem.xml.ISaxConst;
import org.xwiki.shaded.wikimodel.wem.xml.ITagListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTagNotifier
implements ISaxConst {
    protected static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    protected ITagListener fListener;

    public AbstractTagNotifier(ITagListener listener) {
        this.fListener = listener;
    }

    private Map<String, String> addParams(Map<String, String> map, String ... params) {
        for (int i = 0; i < params.length; ++i) {
            String key = params[i];
            String value = ++i < params.length ? params[i] : null;
            map.put(key, value);
        }
        return map;
    }

    private Map<String, String> getParamsMap(Iterable<WikiParameter> params) {
        Map<String, String> map = this.newParamMap();
        for (WikiParameter param : params) {
            String key = param.getKey();
            String value = param.getValue();
            map.put(key, value);
        }
        return map;
    }

    protected Map<String, String> newParamMap() {
        return new LinkedHashMap<String, String>();
    }

    protected Map<String, String> tagParams(Map<String, String> tagParams, String ... params) {
        if (tagParams == EMPTY_MAP) {
            return this.tagParams(params);
        }
        return this.addParams(tagParams, params);
    }

    protected Map<String, String> tagParams(String ... params) {
        if (params.length == 0) {
            return EMPTY_MAP;
        }
        Map<String, String> map = this.newParamMap();
        return this.addParams(map, params);
    }

    protected Map<String, String> tagParams(WikiFormat format) {
        if (format == null) {
            return EMPTY_MAP;
        }
        List<WikiStyle> styles = format.getStyles();
        if (styles.isEmpty()) {
            return EMPTY_MAP;
        }
        Map<String, String> map = this.newParamMap();
        StringBuffer buf = new StringBuffer();
        for (WikiStyle style : styles) {
            String name = style.toString();
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(name);
        }
        map.put("styles", buf.toString());
        return map;
    }

    protected Map<String, String> tagParams(WikiReference ref) {
        if (ref == null) {
            return EMPTY_MAP;
        }
        return this.tagParams("label", ref.getLabel(), "href", ref.getLink());
    }

    protected Map<String, String> userParams(WikiFormat format) {
        if (format == null) {
            return EMPTY_MAP;
        }
        List<WikiParameter> params = format.getParams();
        return this.getParamsMap(params);
    }

    protected Map<String, String> userParams(WikiParameters params) {
        if (params == null || params.getSize() == 0) {
            return EMPTY_MAP;
        }
        return this.getParamsMap(params);
    }

    protected Map<String, String> userParams(WikiReference ref) {
        if (ref == null) {
            return EMPTY_MAP;
        }
        return this.userParams(ref.getParameters());
    }
}

