/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xwiki.xwiki10;

import org.xwiki.shaded.wikimodel.wem.IWikiPrinter;
import org.xwiki.shaded.wikimodel.wem.PrintTextListener;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;

public class XWikiSerializer
extends PrintTextListener {
    private boolean fNewTableRow;

    public XWikiSerializer(IWikiPrinter printer) {
        super(printer);
    }

    public void beginHeader(int headerLevel, WikiParameters params) {
        this.print("1");
        for (int i = 0; i < headerLevel - 1; ++i) {
            this.print(".1");
        }
        this.print(" ");
    }

    public void beginListItem() {
        this.print("* ");
    }

    public void beginTable(WikiParameters params) {
        this.println("{table}");
    }

    public void beginTableCell(boolean tableHead, WikiParameters params) {
        if (!this.fNewTableRow) {
            this.print("|");
        }
        this.fNewTableRow = false;
    }

    public void beginTableRow(WikiParameters params) {
        this.fNewTableRow = true;
    }

    public void endHeader(int headerLevel, WikiParameters params) {
        this.println();
        this.println();
    }

    public void endList(WikiParameters params, boolean ordered) {
        this.println();
    }

    public void endListItem() {
        this.println();
    }

    public void endParagraph(WikiParameters params) {
        this.println();
        this.println();
    }

    public void endTable(WikiParameters params) {
        this.println("{table}");
        this.println();
    }

    public void endTableRow(WikiParameters params) {
        this.println();
    }

    protected String getEol() {
        return "\n";
    }

    public void onHorizontalLine() {
        this.println("----");
    }

    public void onLineBreak() {
        this.println();
        this.println();
    }

    public void onReference(String ref) {
        if (ref.indexOf("Image") == 0) {
            this.print("{image" + ref.substring(5) + "}");
        } else {
            int index = ref.indexOf("|");
            if (index > 0) {
                String label = ref.substring(index + 1);
                String link = ref.substring(0, index);
                link = link.replaceAll(" ", "_");
                this.print("[" + label + ">" + link + "]");
            } else {
                ref = ref.replaceAll(" ", "_");
                this.print("[" + ref + "]");
            }
        }
    }

    public void onSpecialSymbol(String str) {
        this.print(str);
    }

    public void onTableCaption(String str) {
        this.println(str);
    }

    public void onVerbatimInline(String str, WikiParameters params) {
        this.println("{code}");
        this.println(str);
        this.println("{code}");
    }
}

