/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml;

import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Node;
import org.xwiki.xml.ExtractHandler;

public final class XMLUtils {
    private static final String AMP = "&#38;";
    private static final Pattern AMP_PATTERN = Pattern.compile("&(?:amp|#0*+38|#x0*+26);");
    private static final String APOS = "&#39;";
    private static final Pattern APOS_PATTERN = Pattern.compile("&(?:apos|#0*+39|#x0*+27);");
    private static final String QUOT = "&#34;";
    private static final Pattern QUOT_PATTERN = Pattern.compile("&(?:quot|#0*+34|#x0*+22);");
    private static final String LT = "&#60;";
    private static final Pattern LT_PATTERN = Pattern.compile("&(?:lt|#0*+60|#x0*+3[cC]);");
    private static final String GT = "&#62;";
    private static final Pattern GT_PATTERN = Pattern.compile("&(?:gt|#0*+62|#x0*+3[eE]);");

    private XMLUtils() {
    }

    public static String extractXML(Node node, int start, int length) {
        ExtractHandler handler = null;
        try {
            handler = new ExtractHandler(start, length);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(node), new SAXResult(handler));
            return handler.getResult();
        }
        catch (Throwable t) {
            if (handler != null && handler.isFinished()) {
                return handler.getResult();
            }
            throw new RuntimeException("Failed to extract XML", t);
        }
    }

    public static String escapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        int lastChar = 0;
        for (int n : buff) {
            if (n == 92) {
                str.append('\\');
            } else if (n == 45 && lastChar == 45) {
                str.append('\\');
            }
            str.append((char)n);
            lastChar = n;
        }
        if (lastChar == 45) {
            str.append('\\');
        }
        return str.toString();
    }

    public static String unescapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        boolean escaped = false;
        for (char c : buff) {
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            str.append(c);
            escaped = false;
        }
        return str.toString();
    }

    public static String escape(Object content) {
        return XMLUtils.escapeAttributeValue(content);
    }

    public static String escapeAttributeValue(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block7;
                }
                case '\'': {
                    result.append(APOS);
                    continue block7;
                }
                case '\"': {
                    result.append(QUOT);
                    continue block7;
                }
                case '<': {
                    result.append(LT);
                    continue block7;
                }
                case '>': {
                    result.append(GT);
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeElementContent(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block5;
                }
                case '<': {
                    result.append(LT);
                    continue block5;
                }
                case '>': {
                    result.append(GT);
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String unescape(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        str = APOS_PATTERN.matcher(str).replaceAll("'");
        str = QUOT_PATTERN.matcher(str).replaceAll("\"");
        str = LT_PATTERN.matcher(str).replaceAll("<");
        str = GT_PATTERN.matcher(str).replaceAll(">");
        str = AMP_PATTERN.matcher(str).replaceAll("&");
        return str;
    }
}

