/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.shaded.apache.commons.lang.StringEscapeUtils;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.CommentToken;
import org.xwiki.shaded.htmlcleaner.ContentToken;
import org.xwiki.shaded.htmlcleaner.TagNode;
import org.xwiki.shaded.htmlcleaner.Utils;

public class XWikiDOMSerializer {
    private static final Pattern CDATA_PATTERN = Pattern.compile("<!\\[CDATA\\[.*(\\]\\]>|<!\\[CDATA\\[)", 32);
    private CleanerProperties props;
    private boolean escapeXml;

    public XWikiDOMSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public Document createDOM(TagNode rootNode) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().newDocument();
        Element rootElement = document.createElement(rootNode.getName());
        document.appendChild(rootElement);
        this.createSubnodes(document, rootElement, rootNode.getChildren());
        return document;
    }

    private void flushContent(Document document, Element element, StringBuffer bufferedContent, Object item) {
        if (bufferedContent.length() > 0 && !(item instanceof ContentToken)) {
            String nodeName = element.getNodeName();
            boolean specialCase = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(nodeName) || "style".equalsIgnoreCase(nodeName));
            String content = bufferedContent.toString();
            if (this.escapeXml && !specialCase) {
                content = Utils.escapeXml(content, this.props, true);
            } else if (specialCase) {
                content = this.processCDATABlocks(content);
            }
            if (specialCase) {
                element.appendChild(document.createTextNode("//"));
                element.appendChild(document.createCDATASection("\n" + content + "\n//"));
            } else {
                element.appendChild(document.createTextNode(content));
            }
            bufferedContent.setLength(0);
        }
    }

    private String processCDATABlocks(String content) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = CDATA_PATTERN.matcher(content);
        int cursor = 0;
        while (matcher.find()) {
            result.append(StringEscapeUtils.unescapeHtml(content.substring(cursor, matcher.start())));
            result.append(content.substring(matcher.start() + 9, matcher.end() - matcher.group(1).length()));
            cursor = matcher.end() - matcher.group(1).length() + 3;
        }
        if (cursor < content.length()) {
            result.append(StringEscapeUtils.unescapeHtml(content.substring(cursor)));
        }
        String contentResult = result.toString().replace("<![CDATA[", "").replace("]]>", "");
        return contentResult;
    }

    private void createSubnodes(Document document, Element element, List<Object> tagChildren) {
        StringBuffer bufferedContent = new StringBuffer();
        if (tagChildren != null) {
            for (Object item : tagChildren) {
                this.flushContent(document, element, bufferedContent, item);
                if (item instanceof CommentToken) {
                    CommentToken commentToken = (CommentToken)item;
                    Comment comment = document.createComment(commentToken.getContent());
                    element.appendChild(comment);
                    continue;
                }
                if (item instanceof ContentToken) {
                    ContentToken contentToken = (ContentToken)item;
                    String content = contentToken.getContent();
                    bufferedContent.append(content);
                    continue;
                }
                if (item instanceof TagNode) {
                    TagNode subTagNode = (TagNode)item;
                    Element subelement = document.createElement(subTagNode.getName());
                    Map attributes = subTagNode.getAttributes();
                    for (Map.Entry entry : attributes.entrySet()) {
                        String attrName = (String)entry.getKey();
                        String attrValue = (String)entry.getValue();
                        if (this.escapeXml) {
                            attrValue = Utils.escapeXml(attrValue, this.props, true);
                        }
                        subelement.setAttribute(attrName, attrValue);
                    }
                    this.createSubnodes(document, subelement, subTagNode.getChildren());
                    element.appendChild(subelement);
                    continue;
                }
                if (!(item instanceof List)) continue;
                List sublist = (List)item;
                this.createSubnodes(document, element, sublist);
            }
            this.flushContent(document, element, bufferedContent, null);
        }
    }
}

