/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;
import org.xwiki.shaded.apache.commons.beanutils.BeanUtilsBean;
import org.xwiki.shaded.apache.commons.beanutils.ConvertUtils;

@Component
@Singleton
public class ConvertUtilsConverter
implements Converter,
Initializable {
    @Override
    public void initialize() {
        BeanUtilsBean.getInstance().getConvertUtils().register(true, false, 0);
    }

    private <T> T convert(Class<T> targetType, Object sourceValue) {
        try {
            return (T)ConvertUtils.convert(sourceValue, targetType);
        }
        catch (org.xwiki.shaded.apache.commons.beanutils.ConversionException ex) {
            throw new ConversionException("Error while performing type conversion", ex);
        }
    }

    @Override
    public <T> T convert(Type targetType, Object sourceValue) {
        Class clazz;
        if (targetType instanceof Class) {
            clazz = (Class)targetType;
        } else if (targetType instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)targetType).getRawType();
        } else {
            throw new ConversionException("Unknown type [" + targetType + "]");
        }
        return this.convert(clazz, sourceValue);
    }
}

