/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroIdFactory;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;

@Component
@Singleton
public class DefaultMacroIdFactory
implements MacroIdFactory {
    private static final String INVALID_MACRO_ID_FORMAT = "Invalid macro id format [%s]";
    @Inject
    private SyntaxFactory syntaxFactory;

    @Override
    public MacroId createMacroId(String macroIdAsString) throws ParseException {
        MacroId macroId;
        String[] hintParts = macroIdAsString.split("/");
        if (hintParts.length == 3) {
            Syntax syntax;
            try {
                syntax = this.syntaxFactory.createSyntaxFromIdString(String.format("%s/%s", hintParts[1], hintParts[2]));
            }
            catch (ParseException e) {
                throw new ParseException(String.format(INVALID_MACRO_ID_FORMAT, macroIdAsString), e);
            }
            macroId = new MacroId(hintParts[0], syntax);
        } else if (hintParts.length == 1) {
            macroId = new MacroId(macroIdAsString);
        } else {
            throw new ParseException(String.format(INVALID_MACRO_ID_FORMAT, macroIdAsString));
        }
        return macroId;
    }
}

