/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiXHTMLWhitespaceXMLFilter;
import org.xwiki.shaded.wikimodel.wem.xhtml.filter.AccumulationXMLFilter;
import org.xwiki.shaded.wikimodel.wem.xhtml.filter.DTDXMLFilter;
import org.xwiki.shaded.xml.sax.SAXException;
import org.xwiki.shaded.xml.sax.XMLReader;
import org.xwiki.xml.EntityResolver;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Named(value="xwiki")
@Singleton
public class XWikiXMLReaderFactory
implements XMLReaderFactory {
    @Inject
    private XMLReaderFactory xmlReaderFactory;
    @Inject
    protected EntityResolver entityResolver;

    @Override
    public XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        XWikiXHTMLWhitespaceXMLFilter xmlReader;
        try {
            XMLReader xr = this.xmlReaderFactory.createXMLReader();
            DTDXMLFilter dtdFilter = new DTDXMLFilter(xr);
            AccumulationXMLFilter accumulationFilter = new AccumulationXMLFilter(dtdFilter);
            XWikiXHTMLWhitespaceXMLFilter whitespaceFilter = new XWikiXHTMLWhitespaceXMLFilter(accumulationFilter);
            whitespaceFilter.setEntityResolver(this.entityResolver);
            xmlReader = whitespaceFilter;
        }
        catch (Exception e) {
            throw new SAXException("Failed to create XML reader", e);
        }
        return xmlReader;
    }
}

