/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20.reference;

import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.ResourceReferenceTypeSerializer;
import org.xwiki.shaded.apache.commons.lang3.StringUtils;

@Component
@Named(value="xwiki/2.0/doc")
@Singleton
public class DocumentReferenceTypeSerializer
implements ResourceReferenceTypeSerializer {
    private static final String[] ESCAPE_REPLACEMENTS_REFERENCE = new String[]{"\\?", "\\@", "\\#"};
    private static final String[] ESCAPES_REFERENCE = new String[]{"?", "@", "#"};
    private static final String[] ESCAPE_REPLACEMENTS_EXTRA = new String[]{"\\?", "\\@", "\\#", "\\\\"};
    private static final String[] ESCAPES_EXTRA = new String[]{"?", "@", "#", "\\"};

    @Override
    public String serialize(ResourceReference reference) {
        String queryString;
        String anchor;
        StringBuilder buffer = new StringBuilder();
        if (reference.getReference() != null) {
            String normalizedReference = this.addEscapesToReferencePart(reference.getReference());
            buffer.append(normalizedReference);
        }
        if ((anchor = reference.getParameter("anchor")) != null) {
            buffer.append('#');
            buffer.append(this.addEscapesToExtraParts(anchor));
        }
        if ((queryString = reference.getParameter("queryString")) != null) {
            buffer.append('?');
            buffer.append(this.addEscapesToExtraParts(queryString));
        }
        return buffer.toString();
    }

    protected String addEscapesToReferencePart(String text) {
        return StringUtils.replaceEach(text, ESCAPES_REFERENCE, ESCAPE_REPLACEMENTS_REFERENCE);
    }

    protected String addEscapesToExtraParts(String text) {
        return StringUtils.replaceEach(text, ESCAPES_EXTRA, ESCAPE_REPLACEMENTS_EXTRA);
    }
}

