/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.dom4j.io;

import org.xwiki.shaded.dom4j.io.JAXPHelper;
import org.xwiki.shaded.xml.sax.SAXException;
import org.xwiki.shaded.xml.sax.SAXNotRecognizedException;
import org.xwiki.shaded.xml.sax.SAXNotSupportedException;
import org.xwiki.shaded.xml.sax.XMLReader;
import org.xwiki.shaded.xml.sax.helpers.XMLReaderFactory;

class SAXHelper {
    private static boolean loggedWarning = true;

    protected SAXHelper() {
    }

    public static boolean setParserProperty(XMLReader reader, String propertyName, Object value) {
        try {
            reader.setProperty(propertyName, value);
            return true;
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean setParserFeature(XMLReader reader, String featureName, boolean value) {
        try {
            reader.setFeature(featureName, value);
            return true;
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        return false;
    }

    public static XMLReader createXMLReader(boolean validating) throws SAXException {
        XMLReader reader = null;
        if (reader == null) {
            reader = SAXHelper.createXMLReaderViaJAXP(validating, true);
        }
        if (reader == null) {
            try {
                reader = XMLReaderFactory.createXMLReader();
            }
            catch (Exception e) {
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use SAX to load a SAX XMLReader ");
                    System.out.println("Warning: Exception was: " + e);
                    System.out.println("Warning: I will print the stack trace then carry on using the default SAX parser");
                    e.printStackTrace();
                }
                throw new SAXException(e);
            }
        }
        if (reader == null) {
            throw new SAXException("Couldn't create SAX reader");
        }
        return reader;
    }

    protected static XMLReader createXMLReaderViaJAXP(boolean validating, boolean namespaceAware) {
        try {
            return JAXPHelper.createXMLReader(validating, namespaceAware);
        }
        catch (Throwable e) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to load a SAX XMLReader");
                    System.out.println("Warning: Exception was: " + e);
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    protected static boolean isVerboseErrorReporting() {
        try {
            String flag = System.getProperty("org.xwiki.shaded.dom4j.verbose");
            if (flag != null && flag.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

