/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import org.xwiki.shaded.htmlcleaner.BaseToken;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.CommentNode;
import org.xwiki.shaded.htmlcleaner.ContentNode;
import org.xwiki.shaded.htmlcleaner.HtmlSerializer;
import org.xwiki.shaded.htmlcleaner.TagNode;
import org.xwiki.shaded.htmlcleaner.Utils;

public class CompactHtmlSerializer
extends HtmlSerializer {
    private int openPreTags = 0;

    public CompactHtmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        boolean isPreTag = "pre".equalsIgnoreCase(tagNode.getName());
        if (isPreTag) {
            ++this.openPreTags;
        }
        this.serializeOpenTag(tagNode, writer, false);
        List tagChildren = tagNode.getChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator childrenIt = tagChildren.listIterator();
            while (childrenIt.hasNext()) {
                String content;
                Object item = childrenIt.next();
                if (item instanceof ContentNode) {
                    content = item.toString();
                    if (this.openPreTags > 0) {
                        writer.write(content);
                        continue;
                    }
                    boolean startsWithSpace = content.length() > 0 && Character.isWhitespace(content.charAt(0));
                    boolean endsWithSpace = content.length() > 1 && Character.isWhitespace(content.charAt(content.length() - 1));
                    String string = content = this.dontEscape(tagNode) ? content.trim() : this.escapeText(content.trim());
                    if (startsWithSpace) {
                        writer.write(32);
                    }
                    if (content.length() != 0) {
                        writer.write(content);
                        if (endsWithSpace) {
                            writer.write(32);
                        }
                    }
                    if (!childrenIt.hasNext()) continue;
                    if (!Utils.isWhitespaceString(childrenIt.next())) {
                        writer.write("\n");
                    }
                    childrenIt.previous();
                    continue;
                }
                if (item instanceof CommentNode) {
                    content = ((CommentNode)item).getCommentedContent().trim();
                    writer.write(content);
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                ((BaseToken)item).serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
            if (isPreTag) {
                --this.openPreTags;
            }
        }
    }
}

