/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.xwiki.shaded.htmlcleaner.BaseToken;
import org.xwiki.shaded.htmlcleaner.TagToken;

public class TagInfo {
    protected static final int HEAD_AND_BODY = 0;
    protected static final int HEAD = 1;
    protected static final int BODY = 2;
    protected static final int CONTENT_ALL = 0;
    protected static final int CONTENT_NONE = 1;
    protected static final int CONTENT_TEXT = 2;
    private String name;
    private int contentType;
    private Set mustCloseTags = new HashSet();
    private Set higherTags = new HashSet();
    private Set childTags = new HashSet();
    private Set permittedTags = new HashSet();
    private Set copyTags = new HashSet();
    private Set continueAfterTags = new HashSet();
    private int belongsTo = 2;
    private String requiredParent = null;
    private String fatalTag = null;
    private boolean deprecated = false;
    private boolean unique = false;
    private boolean ignorePermitted = false;

    public TagInfo(String name, int contentType, int belongsTo, boolean depricated, boolean unique, boolean ignorePermitted) {
        this.name = name;
        this.contentType = contentType;
        this.belongsTo = belongsTo;
        this.deprecated = depricated;
        this.unique = unique;
        this.ignorePermitted = ignorePermitted;
    }

    public void defineFatalTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag;
            this.fatalTag = currTag = tokenizer.nextToken();
            this.higherTags.add(currTag);
        }
    }

    public void defineRequiredEnclosingTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag;
            this.requiredParent = currTag = tokenizer.nextToken();
            this.higherTags.add(currTag);
        }
    }

    public void defineForbiddenTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.permittedTags.add(currTag);
        }
    }

    public void defineAllowedChildrenTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.childTags.add(currTag);
        }
    }

    public void defineHigherLevelTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.higherTags.add(currTag);
        }
    }

    public void defineCloseBeforeCopyInsideTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.copyTags.add(currTag);
            this.mustCloseTags.add(currTag);
        }
    }

    public void defineCloseInsideCopyAfterTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.continueAfterTags.add(currTag);
        }
    }

    public void defineCloseBeforeTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.mustCloseTags.add(currTag);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getContentType() {
        return this.contentType;
    }

    public Set getMustCloseTags() {
        return this.mustCloseTags;
    }

    public void setMustCloseTags(Set mustCloseTags) {
        this.mustCloseTags = mustCloseTags;
    }

    public Set getHigherTags() {
        return this.higherTags;
    }

    public void setHigherTags(Set higherTags) {
        this.higherTags = higherTags;
    }

    public Set getChildTags() {
        return this.childTags;
    }

    public void setChildTags(Set childTags) {
        this.childTags = childTags;
    }

    public Set getPermittedTags() {
        return this.permittedTags;
    }

    public void setPermittedTags(Set permittedTags) {
        this.permittedTags = permittedTags;
    }

    public Set getCopyTags() {
        return this.copyTags;
    }

    public void setCopyTags(Set copyTags) {
        this.copyTags = copyTags;
    }

    public Set getContinueAfterTags() {
        return this.continueAfterTags;
    }

    public void setContinueAfterTags(Set continueAfterTags) {
        this.continueAfterTags = continueAfterTags;
    }

    public String getRequiredParent() {
        return this.requiredParent;
    }

    public void setRequiredParent(String requiredParent) {
        this.requiredParent = requiredParent;
    }

    public int getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(int belongsTo) {
        this.belongsTo = belongsTo;
    }

    public String getFatalTag() {
        return this.fatalTag;
    }

    public void setFatalTag(String fatalTag) {
        this.fatalTag = fatalTag;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isIgnorePermitted() {
        return this.ignorePermitted;
    }

    public boolean isEmptyTag() {
        return 1 == this.contentType;
    }

    public void setIgnorePermitted(boolean ignorePermitted) {
        this.ignorePermitted = ignorePermitted;
    }

    boolean allowsBody() {
        return 1 != this.contentType;
    }

    boolean isHigher(String tagName) {
        return this.higherTags.contains(tagName);
    }

    boolean isCopy(String tagName) {
        return this.copyTags.contains(tagName);
    }

    boolean hasCopyTags() {
        return !this.copyTags.isEmpty();
    }

    boolean isContinueAfter(String tagName) {
        return this.continueAfterTags.contains(tagName);
    }

    boolean hasPermittedTags() {
        return !this.permittedTags.isEmpty();
    }

    boolean isHeadTag() {
        return this.belongsTo == 1;
    }

    boolean isHeadAndBodyTag() {
        return this.belongsTo == 1 || this.belongsTo == 0;
    }

    boolean isMustCloseTag(TagInfo tagInfo) {
        if (tagInfo != null) {
            return this.mustCloseTags.contains(tagInfo.getName()) || tagInfo.contentType == 2;
        }
        return false;
    }

    boolean allowsItem(BaseToken token) {
        TagToken tagToken;
        String tagName;
        if (this.contentType != 1 && token instanceof TagToken && "script".equals(tagName = (tagToken = (TagToken)token).getName())) {
            return true;
        }
        if (0 == this.contentType) {
            if (!this.childTags.isEmpty()) {
                return token instanceof TagToken ? this.childTags.contains(((TagToken)token).getName()) : false;
            }
            if (!this.permittedTags.isEmpty()) {
                return token instanceof TagToken ? !this.permittedTags.contains(((TagToken)token).getName()) : true;
            }
            return true;
        }
        if (2 == this.contentType) {
            return !(token instanceof TagToken);
        }
        return false;
    }

    boolean allowsAnything() {
        return 0 == this.contentType && this.childTags.size() == 0;
    }
}

