/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem;

import org.xwiki.shaded.wikimodel.wem.WikiParameters;

public class WikiReference {
    private final String fLabel;
    private final String fLink;
    private final WikiParameters fParameters;
    private String fString;

    public WikiReference(String link) {
        this(link, null, null);
    }

    public WikiReference(String link, String label) {
        this(link, label, null);
    }

    public WikiReference(String link, String label, WikiParameters params) {
        assert (link != null) : "Link can not be null";
        this.fLink = link;
        this.fLabel = label;
        if (params == null) {
            params = WikiParameters.EMPTY;
        }
        this.fParameters = params;
    }

    public WikiReference(String link, WikiParameters params) {
        this(link, null, params);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WikiReference)) {
            return false;
        }
        WikiReference r = (WikiReference)obj;
        return this.fLink.equals(r.fLink) && (this.fLabel == r.fLabel || this.fLabel != null && this.fLabel.equals(r.fLabel)) && this.fParameters.equals(r.fParameters);
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getLink() {
        return this.fLink;
    }

    public WikiParameters getParameters() {
        return this.fParameters;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.fString == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.fLink);
            if (this.fLabel != null) {
                buf.append("(");
                buf.append(this.fLabel);
                buf.append(")");
            }
            buf.append(this.fParameters);
            this.fString = buf.toString();
        }
        return this.fString;
    }
}

