/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.util;

import java.util.HashMap;
import java.util.Map;

public class HtmlEntityUtil {
    private static Map fCodeMap = new HashMap();
    private static Map fSymbolMap = new HashMap();

    private static void add(String symbol, int code, String descr) {
        CharInfo info = new CharInfo(symbol, code, descr);
        fCodeMap.put(new Integer(code), info);
        fSymbolMap.put(symbol, info);
    }

    public static char getChar(String symbol) {
        CharInfo info = (CharInfo)fSymbolMap.get(symbol);
        return info != null ? (char)info.fCode : (char)'\u0000';
    }

    public static String getDescription(char ch) {
        CharInfo info = (CharInfo)fCodeMap.get(new Integer(ch));
        return info != null ? info.fDescription : null;
    }

    public static String getDescription(String symbol) {
        CharInfo info = (CharInfo)fSymbolMap.get(symbol);
        return info != null ? info.fDescription : null;
    }

    public static String getSymbol(char ch) {
        CharInfo info = (CharInfo)fCodeMap.get(new Integer(ch));
        return info != null ? info.fSymbol : null;
    }

    static {
        HtmlEntityUtil.add("nbsp", 160, "no-break space");
        HtmlEntityUtil.add("iexcl", 161, "inverted exclamation mark");
        HtmlEntityUtil.add("cent", 162, "cent sign");
        HtmlEntityUtil.add("pound", 163, "pound sterling sign");
        HtmlEntityUtil.add("curren", 164, "general currency sign");
        HtmlEntityUtil.add("yen", 165, "yen sign");
        HtmlEntityUtil.add("brvbar", 166, "broken (vertical) bar");
        HtmlEntityUtil.add("sect", 167, "section sign");
        HtmlEntityUtil.add("uml", 168, "umlaut (dieresis)");
        HtmlEntityUtil.add("copy", 169, "copyright sign");
        HtmlEntityUtil.add("ordf", 170, "ordinal indicator, feminine");
        HtmlEntityUtil.add("laquo", 171, "angle quotation mark, left");
        HtmlEntityUtil.add("not", 172, "not sign");
        HtmlEntityUtil.add("shy", 173, "soft hyphen");
        HtmlEntityUtil.add("reg", 174, "registered sign");
        HtmlEntityUtil.add("macr", 175, "macron");
        HtmlEntityUtil.add("deg", 176, "degree sign");
        HtmlEntityUtil.add("plusmn", 177, "plus-or-minus sign");
        HtmlEntityUtil.add("sup2", 178, "superscript two");
        HtmlEntityUtil.add("sup3", 179, "superscript three");
        HtmlEntityUtil.add("acute", 180, "acute accent");
        HtmlEntityUtil.add("micro", 181, "micro sign");
        HtmlEntityUtil.add("para", 182, "pilcrow (paragraph sign)");
        HtmlEntityUtil.add("middot", 183, "middle dot");
        HtmlEntityUtil.add("cedil", 184, "cedilla");
        HtmlEntityUtil.add("sup1", 185, "superscript one");
        HtmlEntityUtil.add("ordm", 186, "ordinal indicator, masculine");
        HtmlEntityUtil.add("raquo", 187, "angle quotation mark, right");
        HtmlEntityUtil.add("frac14", 188, "fraction one-quarter");
        HtmlEntityUtil.add("frac12", 189, "fraction one-half");
        HtmlEntityUtil.add("frac34", 190, "fraction three-quarters");
        HtmlEntityUtil.add("iquest", 191, "inverted question mark");
        HtmlEntityUtil.add("Agrave", 192, "capital A, grave accent");
        HtmlEntityUtil.add("Aacute", 193, "capital A, acute accent");
        HtmlEntityUtil.add("Acirc", 194, "capital A, circumflex accent");
        HtmlEntityUtil.add("Atilde", 195, "capital A, tilde");
        HtmlEntityUtil.add("Auml", 196, "capital A, dieresis or umlaut mark");
        HtmlEntityUtil.add("Aring", 197, "capital A, ring");
        HtmlEntityUtil.add("AElig", 198, "capital AE diphthong (ligature)");
        HtmlEntityUtil.add("Ccedil", 199, "capital C, cedilla");
        HtmlEntityUtil.add("Egrave", 200, "capital E, grave accent");
        HtmlEntityUtil.add("Eacute", 201, "capital E, acute accent");
        HtmlEntityUtil.add("Ecirc", 202, "capital E, circumflex accent");
        HtmlEntityUtil.add("Euml", 203, "capital E, dieresis or umlaut mark");
        HtmlEntityUtil.add("Igrave", 204, "capital I, grave accent");
        HtmlEntityUtil.add("Iacute", 205, "capital I, acute accent");
        HtmlEntityUtil.add("Icirc", 206, "capital I, circumflex accent");
        HtmlEntityUtil.add("Iuml", 207, "capital I, dieresis or umlaut mark");
        HtmlEntityUtil.add("ETH", 208, "capital Eth, Icelandic");
        HtmlEntityUtil.add("Ntilde", 209, "capital N, tilde");
        HtmlEntityUtil.add("Ograve", 210, "capital O, grave accent");
        HtmlEntityUtil.add("Oacute", 211, "capital O, acute accent");
        HtmlEntityUtil.add("Ocirc", 212, "capital O, circumflex accent");
        HtmlEntityUtil.add("Otilde", 213, "capital O, tilde");
        HtmlEntityUtil.add("Ouml", 214, "capital O, dieresis or umlaut mark");
        HtmlEntityUtil.add("times", 215, "multiply sign");
        HtmlEntityUtil.add("Oslash", 216, "capital O, slash");
        HtmlEntityUtil.add("Ugrave", 217, "capital U, grave accent");
        HtmlEntityUtil.add("Uacute", 218, "capital U, acute accent");
        HtmlEntityUtil.add("Ucirc", 219, "capital U, circumflex accent");
        HtmlEntityUtil.add("Uuml", 220, "capital U, dieresis or umlaut mark");
        HtmlEntityUtil.add("Yacute", 221, "capital Y, acute accent");
        HtmlEntityUtil.add("THORN", 222, "capital THORN, Icelandic");
        HtmlEntityUtil.add("szlig", 223, "small sharp s, German (sz ligature)");
        HtmlEntityUtil.add("agrave", 224, "small a, grave accent");
        HtmlEntityUtil.add("aacute", 225, "small a, acute accent");
        HtmlEntityUtil.add("acirc", 226, "small a, circumflex accent");
        HtmlEntityUtil.add("atilde", 227, "small a, tilde");
        HtmlEntityUtil.add("auml", 228, "small a, dieresis or umlaut mark");
        HtmlEntityUtil.add("aring", 229, "small a, ring");
        HtmlEntityUtil.add("aelig", 230, "small ae diphthong (ligature)");
        HtmlEntityUtil.add("ccedil", 231, "small c, cedilla");
        HtmlEntityUtil.add("egrave", 232, "small e, grave accent");
        HtmlEntityUtil.add("eacute", 233, "small e, acute accent");
        HtmlEntityUtil.add("ecirc", 234, "small e, circumflex accent");
        HtmlEntityUtil.add("euml", 235, "small e, dieresis or umlaut mark");
        HtmlEntityUtil.add("igrave", 236, "small i, grave accent");
        HtmlEntityUtil.add("iacute", 237, "small i, acute accent");
        HtmlEntityUtil.add("icirc", 238, "small i, circumflex accent");
        HtmlEntityUtil.add("iuml", 239, "small i, dieresis or umlaut mark");
        HtmlEntityUtil.add("eth", 240, "small eth, Icelandic");
        HtmlEntityUtil.add("ntilde", 241, "small n, tilde");
        HtmlEntityUtil.add("ograve", 242, "small o, grave accent");
        HtmlEntityUtil.add("oacute", 243, "small o, acute accent");
        HtmlEntityUtil.add("ocirc", 244, "small o, circumflex accent");
        HtmlEntityUtil.add("otilde", 245, "small o, tilde");
        HtmlEntityUtil.add("ouml", 246, "small o, dieresis or umlaut mark");
        HtmlEntityUtil.add("divide", 247, "divide sign");
        HtmlEntityUtil.add("oslash", 248, "small o, slash");
        HtmlEntityUtil.add("ugrave", 249, "small u, grave accent");
        HtmlEntityUtil.add("uacute", 250, "small u, acute accent");
        HtmlEntityUtil.add("ucirc", 251, "small u, circumflex accent");
        HtmlEntityUtil.add("uuml", 252, "small u, dieresis or umlaut mark");
        HtmlEntityUtil.add("yacute", 253, "small y, acute accent");
        HtmlEntityUtil.add("thorn", 254, "small thorn, Icelandic");
        HtmlEntityUtil.add("yuml", 255, "small y, dieresis or umlaut mark");
        HtmlEntityUtil.add("fnof", 192, "latin small f with hook, =function, =florin, U0192 ISOtech");
        HtmlEntityUtil.add("Alpha", 913, "greek capital letter alpha,  U0391");
        HtmlEntityUtil.add("Beta", 914, "greek capital letter beta,  U0392");
        HtmlEntityUtil.add("Gamma", 915, "greek capital letter gamma,  U0393 ISOgrk3");
        HtmlEntityUtil.add("Delta", 916, "greek capital letter delta,  U0394 ISOgrk3");
        HtmlEntityUtil.add("Epsilon", 917, "greek capital letter epsilon,  U0395");
        HtmlEntityUtil.add("Zeta", 918, "greek capital letter zeta,  U0396");
        HtmlEntityUtil.add("Eta", 919, "greek capital letter eta,  U0397");
        HtmlEntityUtil.add("Theta", 920, "greek capital letter theta,  U0398 ISOgrk3");
        HtmlEntityUtil.add("Iota", 921, "greek capital letter iota,  U0399");
        HtmlEntityUtil.add("Kappa", 922, "greek capital letter kappa,  U039A");
        HtmlEntityUtil.add("Lambda", 923, "greek capital letter lambda,  U039B ISOgrk3");
        HtmlEntityUtil.add("Mu", 924, "greek capital letter mu,  U039C");
        HtmlEntityUtil.add("Nu", 925, "greek capital letter nu,  U039D");
        HtmlEntityUtil.add("Xi", 926, "greek capital letter xi,  U039E ISOgrk3");
        HtmlEntityUtil.add("Omicron", 927, "greek capital letter omicron,  U039F");
        HtmlEntityUtil.add("Pi", 928, "greek capital letter pi,  U03A0 ISOgrk3");
        HtmlEntityUtil.add("Rho", 929, "greek capital letter rho,  U03A1");
        HtmlEntityUtil.add("Sigma", 931, "greek capital letter sigma,  U03A3 ISOgrk3");
        HtmlEntityUtil.add("Tau", 932, "greek capital letter tau,  U03A4");
        HtmlEntityUtil.add("Upsi", 933, "greek capital letter upsilon,  U03A5 ISOgrk3");
        HtmlEntityUtil.add("Phi", 934, "greek capital letter phi,  U03A6 ISOgrk3");
        HtmlEntityUtil.add("Chi", 935, "greek capital letter chi,  U03A7");
        HtmlEntityUtil.add("Psi", 936, "greek capital letter psi,  U03A8 ISOgrk3");
        HtmlEntityUtil.add("Omega", 937, "greek capital letter omega,  U03A9 ISOgrk3");
        HtmlEntityUtil.add("alpha", 945, "greek small letter alpha, U03B1 ISOgrk3");
        HtmlEntityUtil.add("beta", 946, "greek small letter beta,  U03B2 ISOgrk3");
        HtmlEntityUtil.add("gamma", 947, "greek small letter gamma,  U03B3 ISOgrk3");
        HtmlEntityUtil.add("delta", 948, "greek small letter delta,  U03B4 ISOgrk3");
        HtmlEntityUtil.add("epsi", 949, "greek small letter epsilon,  U03B5 ISOgrk3");
        HtmlEntityUtil.add("zeta", 950, "greek small letter zeta,  U03B6 ISOgrk3");
        HtmlEntityUtil.add("eta", 951, "greek small letter eta,  U03B7 ISOgrk3");
        HtmlEntityUtil.add("theta", 952, "greek small letter theta,  U03B8 ISOgrk3");
        HtmlEntityUtil.add("iota", 953, "greek small letter iota,  U03B9 ISOgrk3");
        HtmlEntityUtil.add("kappa", 954, "greek small letter kappa,  U03BA ISOgrk3");
        HtmlEntityUtil.add("lambda", 955, "greek small letter lambda,  U03BB ISOgrk3");
        HtmlEntityUtil.add("mu", 956, "greek small letter mu,  U03BC ISOgrk3");
        HtmlEntityUtil.add("nu", 957, "greek small letter nu,  U03BD ISOgrk3");
        HtmlEntityUtil.add("xi", 958, "greek small letter xi,  U03BE ISOgrk3");
        HtmlEntityUtil.add("omicron", 959, "greek small letter omicron,  U03BF NEW");
        HtmlEntityUtil.add("pi", 960, "greek small letter pi,  U03C0 ISOgrk3");
        HtmlEntityUtil.add("rho", 961, "greek small letter rho,  U03C1 ISOgrk3");
        HtmlEntityUtil.add("sigmaf", 962, "greek small letter final sigma,  U03C2 ISOgrk3");
        HtmlEntityUtil.add("sigma", 963, "greek small letter sigma,  U03C3 ISOgrk3");
        HtmlEntityUtil.add("tau", 964, "greek small letter tau,  U03C4 ISOgrk3");
        HtmlEntityUtil.add("upsi", 965, "greek small letter upsilon,  U03C5 ISOgrk3");
        HtmlEntityUtil.add("phi", 966, "greek small letter phi,  U03C6 ISOgrk3");
        HtmlEntityUtil.add("chi", 967, "greek small letter chi,  U03C7 ISOgrk3");
        HtmlEntityUtil.add("psi", 968, "greek small letter psi,  U03C8 ISOgrk3");
        HtmlEntityUtil.add("omega", 969, "greek small letter omega,  U03C9 ISOgrk3");
        HtmlEntityUtil.add("theta", 977, "greek small letter theta symbol,  U03D1 NEW");
        HtmlEntityUtil.add("upsih", 978, "greek upsilon with hook symbol,  U03D2 NEW");
        HtmlEntityUtil.add("piv", 982, "greek pi symbol,  U03D6 ISOgrk3");
        HtmlEntityUtil.add("bull", 8226, "bullet, =black small circle, U2022 ISOpub ");
        HtmlEntityUtil.add("hellip", 8230, "horizontal ellipsis, =three dot leader, U2026 ISOpub ");
        HtmlEntityUtil.add("prime", 8242, "prime, =minutes, =feet, U2032 ISOtech");
        HtmlEntityUtil.add("Prime", 8243, "double prime, =seconds, =inches, U2033 ISOtech");
        HtmlEntityUtil.add("oline", 8254, "overline, =spacing overscore, U203E NEW");
        HtmlEntityUtil.add("frasl", 8260, "fraction slash, U2044 NEW");
        HtmlEntityUtil.add("weierp", 8472, "script capital P, =power set, =Weierstrass p, U2118 ISOamso");
        HtmlEntityUtil.add("image", 8465, "blackletter capital I, =imaginary part, U2111 ISOamso");
        HtmlEntityUtil.add("real", 8476, "blackletter capital R, =real part symbol, U211C ISOamso");
        HtmlEntityUtil.add("trade", 8482, "trade mark sign, U2122 ISOnum");
        HtmlEntityUtil.add("alefsym", 8501, "alef symbol, =first transfinite cardinal, U2135 NEW");
        HtmlEntityUtil.add("larr", 8592, "leftwards arrow, U2190 ISOnum");
        HtmlEntityUtil.add("uarr", 8593, "upwards arrow, U2191 ISOnum");
        HtmlEntityUtil.add("rarr", 8594, "rightwards arrow, U2192 ISOnum");
        HtmlEntityUtil.add("darr", 8595, "downwards arrow, U2193 ISOnum");
        HtmlEntityUtil.add("harr", 8596, "left right arrow, U2194 ISOamsa");
        HtmlEntityUtil.add("crarr", 8629, "downwards arrow with corner leftwards, =carriage return, U21B5 NEW");
        HtmlEntityUtil.add("lArr", 8656, "leftwards double arrow, U21D0 ISOtech");
        HtmlEntityUtil.add("uArr", 8657, "upwards double arrow, U21D1 ISOamsa");
        HtmlEntityUtil.add("rArr", 8658, "rightwards double arrow, U21D2 ISOtech");
        HtmlEntityUtil.add("dArr", 8659, "downwards double arrow, U21D3 ISOamsa");
        HtmlEntityUtil.add("hArr", 8660, "left right double arrow, U21D4 ISOamsa");
        HtmlEntityUtil.add("forall", 8704, "for all, U2200 ISOtech");
        HtmlEntityUtil.add("part", 8706, "partial differential, U2202 ISOtech ");
        HtmlEntityUtil.add("exist", 8707, "there exists, U2203 ISOtech");
        HtmlEntityUtil.add("empty", 8709, "empty set, =null set, =diameter, U2205 ISOamso");
        HtmlEntityUtil.add("nabla", 8711, "nabla, =backward difference, U2207 ISOtech");
        HtmlEntityUtil.add("isin", 8712, "element of, U2208 ISOtech");
        HtmlEntityUtil.add("notin", 8713, "not an element of, U2209 ISOtech");
        HtmlEntityUtil.add("ni", 8715, "contains as member, U220B ISOtech");
        HtmlEntityUtil.add("prod", 8719, "n-ary product, =product sign, U220F ISOamsb");
        HtmlEntityUtil.add("sum", 8722, "n-ary sumation, U2211 ISOamsb");
        HtmlEntityUtil.add("minus", 8722, "minus sign, U2212 ISOtech");
        HtmlEntityUtil.add("lowast", 8727, "asterisk operator, U2217 ISOtech");
        HtmlEntityUtil.add("radic", 8730, "square root, =radical sign, U221A ISOtech");
        HtmlEntityUtil.add("prop", 8733, "proportional to, U221D ISOtech");
        HtmlEntityUtil.add("infin", 8734, "infinity, U221E ISOtech");
        HtmlEntityUtil.add("ang", 8736, "angle, U2220 ISOamso");
        HtmlEntityUtil.add("and", 8869, "logical and, =wedge, U2227 ISOtech");
        HtmlEntityUtil.add("or", 8870, "logical or, =vee, U2228 ISOtech");
        HtmlEntityUtil.add("cap", 8745, "intersection, =cap, U2229 ISOtech");
        HtmlEntityUtil.add("cup", 8746, "union, =cup, U222A ISOtech");
        HtmlEntityUtil.add("int", 8747, "integral, U222B ISOtech");
        HtmlEntityUtil.add("there4", 8756, "therefore, U2234 ISOtech");
        HtmlEntityUtil.add("sim", 8764, "tilde operator, =varies with, =similar to, U223C ISOtech");
        HtmlEntityUtil.add("cong", 8773, "approximately equal to, U2245 ISOtech");
        HtmlEntityUtil.add("asymp", 8773, "almost equal to, =asymptotic to, U2248 ISOamsr");
        HtmlEntityUtil.add("ne", 8800, "not equal to, U2260 ISOtech");
        HtmlEntityUtil.add("equiv", 8801, "identical to, U2261 ISOtech");
        HtmlEntityUtil.add("le", 8804, "less-than or equal to, U2264 ISOtech");
        HtmlEntityUtil.add("ge", 8805, "greater-than or equal to, U2265 ISOtech");
        HtmlEntityUtil.add("sub", 8834, "subset of, U2282 ISOtech");
        HtmlEntityUtil.add("sup", 8835, "superset of, U2283 ISOtech");
        HtmlEntityUtil.add("nsub", 8836, "not a subset of, U2284 ISOamsn");
        HtmlEntityUtil.add("sube", 8838, "subset of or equal to, U2286 ISOtech");
        HtmlEntityUtil.add("supe", 8839, "superset of or equal to, U2287 ISOtech");
        HtmlEntityUtil.add("oplus", 8853, "circled plus, =direct sum, U2295 ISOamsb");
        HtmlEntityUtil.add("otimes", 8855, "circled times, =vector product, U2297 ISOamsb");
        HtmlEntityUtil.add("perp", 8869, "up tack, =orthogonal to, =perpendicular, U22A5 ISOtech");
        HtmlEntityUtil.add("sdot", 8901, "dot operator, U22C5 ISOamsb");
        HtmlEntityUtil.add("lceil", 8968, "left ceiling, =apl upstile, U2308, ISOamsc ");
        HtmlEntityUtil.add("rceil", 8969, "right ceiling, U2309, ISOamsc ");
        HtmlEntityUtil.add("lfloor", 8970, "left floor, =apl downstile, U230A, ISOamsc ");
        HtmlEntityUtil.add("rfloor", 8971, "right floor, U230B, ISOamsc ");
        HtmlEntityUtil.add("lang", 9001, "left-pointing angle bracket, =bra, U2329 ISOtech");
        HtmlEntityUtil.add("rang", 9002, "right-pointing angle bracket, =ket, U232A ISOtech");
        HtmlEntityUtil.add("loz", 9674, "lozenge, U25CA ISOpub");
        HtmlEntityUtil.add("spades", 9824, "black spade suit, U2660 ISOpub");
        HtmlEntityUtil.add("clubs", 9827, "black club suit, =shamrock, U2663 ISOpub");
        HtmlEntityUtil.add("hearts", 9829, "black heart suit, =valentine, U2665 ISOpub");
        HtmlEntityUtil.add("diams", 9830, "black diamond suit, U2666 ISOpub");
        HtmlEntityUtil.add("quot", 34, "quotation mark, =apl quote, U0022 ISOnum");
        HtmlEntityUtil.add("amp", 38, "ampersand, U0026 ISOnum");
        HtmlEntityUtil.add("lt", 60, "less-than sign, U003C ISOnum");
        HtmlEntityUtil.add("gt", 62, "greater-than sign, U003E ISOnum");
        HtmlEntityUtil.add("OElig", 338, "latin capital ligature oe, U0152 ISOlat2");
        HtmlEntityUtil.add("oelig", 339, "latin small ligature oe, U0153 ISOlat2");
        HtmlEntityUtil.add("Scaron", 352, "latin capital letter s with caron, U0160 ISOlat2");
        HtmlEntityUtil.add("scaron", 353, "latin small letter s with caron, U0161 ISOlat2");
        HtmlEntityUtil.add("Yuml", 376, "latin capital letter y with diaeresis, U0178 ISOlat2");
        HtmlEntityUtil.add("circ", 710, "modifier letter circumflex accent, U02C6 ISOpub");
        HtmlEntityUtil.add("tilde", 732, "small tilde, U02DC ISOdia");
        HtmlEntityUtil.add("ensp", 8194, "en space, U2002 ISOpub");
        HtmlEntityUtil.add("emsp", 8195, "em space, U2003 ISOpub");
        HtmlEntityUtil.add("thinsp", 8201, "thin space, U2009 ISOpub");
        HtmlEntityUtil.add("zwnj", 8204, "zero width non-joiner, U200C NEW RFC 2070");
        HtmlEntityUtil.add("zwj", 8205, "zero width joiner, U200D NEW RFC 2070");
        HtmlEntityUtil.add("lrm", 8206, "left-to-right mark, U200E NEW RFC 2070");
        HtmlEntityUtil.add("rlm", 8207, "right-to-left mark, U200F NEW RFC 2070");
        HtmlEntityUtil.add("ndash", 8211, "en dash, U2013 ISOpub");
        HtmlEntityUtil.add("mdash", 8212, "em dash, U2014 ISOpub");
        HtmlEntityUtil.add("lsquo", 8216, "left single quotation mark, U2018 ISOnum");
        HtmlEntityUtil.add("rsquo", 8217, "right single quotation mark, U2019 ISOnum");
        HtmlEntityUtil.add("sbquo", 8218, "single low-9 quotation mark, U201A NEW");
        HtmlEntityUtil.add("ldquo", 8220, "left double quotation mark, U201C ISOnum");
        HtmlEntityUtil.add("rdquo", 8221, "right double quotation mark, U201D ISOnum");
        HtmlEntityUtil.add("bdquo", 8222, "double low-9 quotation mark, U201E NEW");
        HtmlEntityUtil.add("dagger", 8224, "dagger, U2020 ISOpub");
        HtmlEntityUtil.add("Dagger", 8225, "double dagger, U2021 ISOpub");
        HtmlEntityUtil.add("permil", 8240, "per mille sign, U2030 ISOtech");
        HtmlEntityUtil.add("lsaquo", 8249, "single left-pointing angle quotation mark, U2039 ISO proposed");
        HtmlEntityUtil.add("rsaquo", 8250, "single right-pointing angle quotation mark, U203A ISO proposed");
    }

    private static class CharInfo {
        int fCode;
        String fDescription;
        String fSymbol;

        CharInfo(String symbol, int code, String description) {
            this.fSymbol = symbol;
            this.fCode = code;
            this.fDescription = description;
        }
    }
}

