/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.util;

import java.util.Stack;
import org.xwiki.shaded.wikimodel.wem.util.ITocListener;

public class TocBuilder {
    protected int fBaseLevel;
    protected Stack<Integer> fBaseLevelStack = new Stack();
    protected int fLevel;
    private ITocListener fListener;
    private final int fMaxHeaderDepth;
    private final int fMaxSectionDepth;
    private int fTotalDepth;

    public TocBuilder(ITocListener listener) {
        this(listener, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public TocBuilder(ITocListener listener, int totalDepth) {
        this(listener, Integer.MAX_VALUE, Integer.MAX_VALUE, totalDepth);
    }

    public TocBuilder(ITocListener listener, int documentDepth, int headerDepth) {
        this(listener, documentDepth, headerDepth, Integer.MAX_VALUE);
    }

    public TocBuilder(ITocListener listener, int documentDepth, int headerDepth, int totalDepth) {
        this.fListener = listener;
        this.fMaxSectionDepth = documentDepth;
        this.fMaxHeaderDepth = headerDepth;
        this.fTotalDepth = totalDepth;
    }

    public void beginDocument() {
        this.fBaseLevelStack.push(new Integer(this.fBaseLevel));
        this.fBaseLevel = this.fLevel;
    }

    public void beginHeader(int level) {
        this.setHeaderLevel(level);
        if (this.checkDepth()) {
            this.fListener.beginItem();
        }
    }

    public boolean checkDepth() {
        int documentDepth = this.fBaseLevelStack.size();
        int headerLevel = this.getHeaderLevel();
        return documentDepth <= this.fMaxSectionDepth && headerLevel <= this.fMaxHeaderDepth && documentDepth + headerLevel <= this.fTotalDepth;
    }

    public void endDocument() {
        this.setHeaderLevel(0);
        Integer level = this.fBaseLevelStack.pop();
        this.fBaseLevel = level;
    }

    public void endHeader() {
        if (this.checkDepth()) {
            this.fListener.endItem();
        }
    }

    protected int getHeaderLevel() {
        return this.fLevel - this.fBaseLevel;
    }

    protected void setHeaderLevel(int level) {
        while (this.fLevel > level + this.fBaseLevel) {
            if (this.checkDepth()) {
                this.fListener.endLevel(this.getHeaderLevel());
            }
            --this.fLevel;
        }
        while (this.fLevel < level + this.fBaseLevel) {
            ++this.fLevel;
            if (!this.checkDepth()) continue;
            this.fListener.beginLevel(this.getHeaderLevel());
        }
    }
}

