/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xhtml;

import org.xwiki.shaded.wikimodel.wem.IWikiPrinter;
import org.xwiki.shaded.wikimodel.wem.PrintTextListener;
import org.xwiki.shaded.wikimodel.wem.ReferenceHandler;
import org.xwiki.shaded.wikimodel.wem.WikiFormat;
import org.xwiki.shaded.wikimodel.wem.WikiPageUtil;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;
import org.xwiki.shaded.wikimodel.wem.util.WikiEntityUtil;

public class PrintInlineListener
extends PrintTextListener {
    public PrintInlineListener(IWikiPrinter printer) {
        super(printer);
    }

    public PrintInlineListener(IWikiPrinter printer, boolean supportImage, boolean supportDownload) {
        super(printer, supportImage, supportDownload);
    }

    public void beginFormat(WikiFormat format) {
        this.print(format.getTags(true));
        if (format.getParams().size() > 0) {
            this.print("<span class='wikimodel-parameters'" + format.getParams() + ">");
        }
    }

    public void beginPropertyInline(String str) {
        this.print("<span class='wikimodel-property' url='" + WikiPageUtil.escapeXmlAttribute(str) + "'>");
    }

    public void endFormat(WikiFormat format) {
        if (format.getParams().size() > 0) {
            this.print("</span>");
        }
        this.print(format.getTags(false));
    }

    public void endPropertyInline(String inlineProperty) {
        this.print("</span>");
    }

    protected String getSymbolEntity(String str) {
        String entity = null;
        if (this.isHtmlEntities()) {
            entity = WikiEntityUtil.getHtmlSymbol(str);
        } else {
            int code = WikiEntityUtil.getHtmlCodeByWikiSymbol(str);
            if (code > 0) {
                entity = "#" + Integer.toString(code);
            }
        }
        if (entity != null) {
            entity = "&" + entity + ";";
            if (str.startsWith(" --")) {
                entity = "&#160;" + entity + " ";
            }
        }
        return entity;
    }

    protected boolean isHtmlEntities() {
        return true;
    }

    protected ReferenceHandler newReferenceHandler() {
        return new ReferenceHandler(this.isSupportImage(), this.isSupportDownload()){

            protected void handleImage(String ref, String label, WikiParameters params) {
                PrintInlineListener.this.print("<img src='" + WikiPageUtil.escapeXmlAttribute(ref) + "'" + params + "/>");
            }

            protected void handleReference(String ref, String label, WikiParameters params) {
                PrintInlineListener.this.print("<a href='" + WikiPageUtil.escapeXmlAttribute(ref) + "'" + params + ">" + WikiPageUtil.escapeXmlString(label) + "</a>");
            }
        };
    }

    public void onEscape(String str) {
        this.print("<span class='wikimodel-escaped'>" + WikiPageUtil.escapeXmlString(str) + "</span>");
    }

    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.print("<span class='wikimodel-extension' extension='" + extensionName + "'" + params + "/>");
    }

    public void onLineBreak() {
        this.print("<br />");
    }

    public void onSpecialSymbol(String str) {
        String entity = this.getSymbolEntity(str);
        if (entity == null) {
            entity = WikiPageUtil.escapeXmlString(str);
        }
        this.print(entity);
    }

    public void onVerbatimInline(String str, WikiParameters params) {
        this.print("<tt class=\"wikimodel-verbatim\"" + params + ">" + WikiPageUtil.escapeXmlString(str) + "</tt>");
    }
}

