/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xhtml.handler;

import java.util.Stack;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;
import org.xwiki.shaded.wikimodel.wem.xhtml.impl.XhtmlHandler;

public class TagHandler {
    private boolean fAccumulateContent;
    private final boolean fContentContainer;
    private final boolean fDocumentContainer;
    private final boolean fRequiresDocument;

    private static boolean requiresParentDocument(XhtmlHandler.TagStack.TagContext context) {
        if (context == null) {
            return true;
        }
        if (context.fHandler == null || !context.fHandler.requiresDocument()) {
            return false;
        }
        boolean inContainer = false;
        for (XhtmlHandler.TagStack.TagContext parent = context.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.fHandler == null) continue;
            inContainer = parent.fHandler.isDocumentContainer();
            break;
        }
        return inContainer;
    }

    public TagHandler(boolean documentContainer, boolean requiresDocument, boolean contentContainer) {
        this.fDocumentContainer = documentContainer;
        this.fRequiresDocument = requiresDocument;
        this.fContentContainer = contentContainer;
    }

    protected void begin(XhtmlHandler.TagStack.TagContext context) {
    }

    public void beginElement(XhtmlHandler.TagStack.TagContext context) {
        Stack insideBlockElementsStack = (Stack)context.getTagStack().getStackParameter("insideBlockElement");
        if (this.isBlockHandler(context)) {
            if (!insideBlockElementsStack.isEmpty() && ((Boolean)insideBlockElementsStack.peek()).booleanValue()) {
                this.beginDocument(context);
                context.getTagStack().setStackParameter("documentParent", context.getParent());
                insideBlockElementsStack = (Stack)context.getTagStack().getStackParameter("insideBlockElement");
            }
            insideBlockElementsStack.push(true);
        }
        this.begin(context);
    }

    protected void end(XhtmlHandler.TagStack.TagContext context) {
    }

    public final void endElement(XhtmlHandler.TagStack.TagContext context) {
        XhtmlHandler.TagStack.TagContext docParent = (XhtmlHandler.TagStack.TagContext)context.getTagStack().getStackParameter("documentParent");
        if (context == docParent) {
            this.endDocument(context);
        }
        this.end(context);
        Stack insideBlockElementsStack = (Stack)context.getTagStack().getStackParameter("insideBlockElement");
        if (this.isBlockHandler(context)) {
            insideBlockElementsStack.pop();
        }
    }

    public boolean isContentContainer() {
        return this.fContentContainer;
    }

    public boolean isDocumentContainer() {
        return this.fDocumentContainer;
    }

    public boolean requiresDocument() {
        return this.fRequiresDocument;
    }

    public void setAccumulateContent(boolean accumulateContent) {
        this.fAccumulateContent = accumulateContent;
    }

    public boolean isAccumulateContent() {
        return this.fAccumulateContent;
    }

    public static void sendEmptyLines(XhtmlHandler.TagStack.TagContext context) {
        int lineCount = (Integer)context.getTagStack().getStackParameter("emptyLinesCount");
        if (lineCount > 0) {
            context.getScannerContext().onEmptyLines(lineCount);
            context.getTagStack().setStackParameter("emptyLinesCount", 0);
        }
    }

    public void initialize(XhtmlHandler.TagStack stack) {
    }

    public boolean isBlockHandler(XhtmlHandler.TagStack.TagContext context) {
        return false;
    }

    protected void beginDocument(XhtmlHandler.TagStack.TagContext context) {
        this.beginDocument(context, null);
    }

    protected void beginDocument(XhtmlHandler.TagStack.TagContext context, WikiParameters params) {
        TagHandler.sendEmptyLines(context);
        if (params == null) {
            context.getScannerContext().beginDocument();
        } else {
            context.getScannerContext().beginDocument(params);
        }
        Object ignoreElements = context.getTagStack().getStackParameter("ignoreElements");
        context.getTagStack().pushStackParameters();
        context.getTagStack().setStackParameter("ignoreElements", ignoreElements);
    }

    protected void endDocument(XhtmlHandler.TagStack.TagContext context) {
        context.getTagStack().popStackParameters();
        context.getScannerContext().endDocument();
    }
}

