/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xhtml.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xwiki.shaded.xml.sax.EntityResolver;
import org.xwiki.shaded.xml.sax.InputSource;
import org.xwiki.shaded.xml.sax.SAXException;

public class LocalEntityResolver
implements EntityResolver {
    private static final Logger log = Logger.getLogger(LocalEntityResolver.class.getName());

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = null;
        try {
            URI uri = new URI(systemId);
            if ("http".equals(uri.getScheme()) || "file".equals(uri.getScheme())) {
                String filename = new File(uri.getPath()).getName();
                InputStream istream = this.getClass().getClassLoader().getResourceAsStream(filename);
                if (istream != null) {
                    source = new InputSource(istream);
                } else {
                    log.warning(String.format("Failed to load resource [%s] locally. Will try to get it online at [%s]", filename, systemId));
                }
            } else {
                log.fine(String.format("Unknown URI scheme [%s] for entity [%s]. Assuming the entity is already resolved and looking for it in the file system.", uri.getScheme(), systemId));
                InputStream istream = this.getClass().getClassLoader().getResourceAsStream(systemId);
                if (istream != null) {
                    source = new InputSource(istream);
                } else {
                    log.fine("Failed to load resource [" + systemId + "] locally.");
                }
            }
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, String.format("Invalid URI [%s]", systemId), e);
        }
        return source;
    }
}

