/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.html;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.shaded.jdom.DocType;
import org.xwiki.shaded.jdom.Document;
import org.xwiki.shaded.jdom.input.DOMBuilder;
import org.xwiki.shaded.jdom.output.Format;
import org.xwiki.shaded.jdom.output.XMLOutputter;

public final class HTMLUtils {
    private static final List<String> OMIT_ELEMENT_CLOSE_SET = Arrays.asList("area", "base", "br", "col", "hr", "img", "input", "link", "meta", "p", "param");

    private HTMLUtils() {
    }

    public static String toString(org.w3c.dom.Document document) {
        return HTMLUtils.toString(document, false, false);
    }

    public static String toString(org.w3c.dom.Document document, boolean omitDeclaration, boolean omitDoctype) {
        DOMBuilder builder = new DOMBuilder();
        Document jdomDoc = builder.build(document);
        Format format = Format.getRawFormat();
        format.setLineSeparator("\n");
        format.setExpandEmptyElements(true);
        format.setOmitDeclaration(omitDeclaration);
        XWikiXMLOutputter outputter = new XWikiXMLOutputter(format, omitDoctype);
        String result = outputter.outputString(jdomDoc);
        for (String specialElement : OMIT_ELEMENT_CLOSE_SET) {
            result = result.replaceAll(MessageFormat.format("<{0}></{0}>", specialElement), MessageFormat.format("<{0}/>", specialElement));
        }
        return result;
    }

    public static void stripHTMLEnvelope(org.w3c.dom.Document document) {
        Element root = document.getDocumentElement();
        if (root.getNodeName().equalsIgnoreCase("html")) {
            Node bodyNode = null;
            Node headNode = null;
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeName().equalsIgnoreCase("head")) {
                    headNode = node;
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("body")) continue;
                bodyNode = node;
            }
            if (headNode != null) {
                root.removeChild(headNode);
            }
            if (bodyNode != null) {
                NodeList bodyChildrenNodes = bodyNode.getChildNodes();
                while (bodyChildrenNodes.getLength() > 0) {
                    root.insertBefore(bodyChildrenNodes.item(0), null);
                }
                root.removeChild(bodyNode);
            }
        }
    }

    public static void stripFirstElementInside(org.w3c.dom.Document document, String parentTagName, String elementTagName) {
        Node parentNode;
        Node pNode;
        NodeList parentNodes = document.getElementsByTagName(parentTagName);
        if (parentNodes.getLength() > 0 && elementTagName.equalsIgnoreCase((pNode = (parentNode = parentNodes.item(0)).getFirstChild()).getNodeName())) {
            NodeList pChildrenNodes = pNode.getChildNodes();
            while (pChildrenNodes.getLength() > 0) {
                parentNode.insertBefore(pChildrenNodes.item(0), null);
            }
            parentNode.removeChild(pNode);
        }
    }

    public static class XWikiXMLOutputter
    extends XMLOutputter {
        private static final Pattern ENTITY = Pattern.compile("&[a-z]+;|&#[0-9a-zA-Z]+;");
        private static final String AMPERSAND = "&";
        private boolean omitDocType;

        public XWikiXMLOutputter(Format format, boolean omitDocType) {
            super(format);
            this.omitDocType = omitDocType;
        }

        @Override
        public String escapeElementEntities(String text) {
            String result;
            if (text.length() == 0) {
                return text;
            }
            int pos1 = text.indexOf("<![CDATA[");
            if (pos1 > -1) {
                int pos2 = text.indexOf("]]>", pos1 + 9);
                if (pos2 + 3 == text.length()) {
                    return text;
                }
                result = this.escapeElementEntities(text.substring(0, pos1));
                result = pos2 + 3 == text.length() ? result + text.substring(pos1) : result + text.substring(pos1, pos2 + 3) + this.escapeElementEntities(text.substring(pos2 + 3));
            } else {
                result = this.escapeAmpersand(text);
                result = result.replaceAll("<", "&lt;");
                result = result.replaceAll(">", "&gt;");
            }
            return result;
        }

        @Override
        public String escapeAttributeEntities(String text) {
            String result = this.escapeElementEntities(text);
            result = result.replaceAll("\"", "&quot;");
            return result;
        }

        private String escapeAmpersand(String text) {
            StringBuffer buffer = new StringBuffer(text);
            int pos = buffer.indexOf(AMPERSAND);
            while (pos > -1 && pos < buffer.length()) {
                Matcher matcher = ENTITY.matcher(buffer.substring(pos));
                if (matcher.lookingAt()) {
                    pos = pos + matcher.end() - matcher.start();
                } else {
                    buffer.replace(pos, pos + 1, "&amp;");
                    pos += 5;
                }
                pos = buffer.indexOf(AMPERSAND, pos);
            }
            return buffer.toString();
        }

        @Override
        protected void printDocType(Writer out, DocType docType) throws IOException {
            if (!this.omitDocType) {
                super.printDocType(out, docType);
            }
        }
    }
}

