/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel;

import java.util.Collections;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.AttachmentTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.ConfluenceImageWikiReference;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.ConfluenceLinkWikiReference;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelParserUtils;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XHTMLXWikiGeneratorListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.AttachmentResourceReference;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.listener.reference.UserResourceReference;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.WikiReference;

public class ConfluenceXWikiGeneratorListener
extends XHTMLXWikiGeneratorListener {
    private StreamParser plainParser;

    public ConfluenceXWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax, StreamParser plainParser) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator, syntax);
        this.plainParser = plainParser;
    }

    public void onReference(WikiReference reference) {
        if (reference instanceof ConfluenceLinkWikiReference) {
            ConfluenceLinkWikiReference confluenceReference = (ConfluenceLinkWikiReference)reference;
            UserResourceReference resourceReference = null;
            if (confluenceReference.getPage() != null) {
                StringBuilder str = new StringBuilder();
                if (confluenceReference.getSpace() != null) {
                    str.append(confluenceReference.getSpace());
                    str.append('.');
                }
                if (confluenceReference.getPage() != null) {
                    str.append(confluenceReference.getPage());
                } else if (confluenceReference.getSpace() != null) {
                    str.append("WebHome");
                }
                DocumentResourceReference documentResourceReference = new DocumentResourceReference(str.toString());
                if (confluenceReference.getAnchor() != null) {
                    documentResourceReference.setAnchor(confluenceReference.getAnchor());
                }
                resourceReference = documentResourceReference;
            } else if (confluenceReference.getSpace() != null) {
                DocumentResourceReference documentResourceReference = new DocumentResourceReference(confluenceReference.getSpace() + ".WebHome");
                if (confluenceReference.getAnchor() != null) {
                    documentResourceReference.setAnchor(confluenceReference.getAnchor());
                }
                resourceReference = documentResourceReference;
            } else if (confluenceReference.getAttachment() != null) {
                AttachmentTagHandler.ConfluenceAttachment attachment = confluenceReference.getAttachment();
                StringBuilder str = new StringBuilder();
                if (attachment.space != null) {
                    str.append(attachment.space);
                    str.append('.');
                }
                if (attachment.page != null) {
                    str.append(attachment.page);
                    str.append('@');
                } else if (attachment.space != null) {
                    str.append("WebHome");
                    str.append('@');
                }
                if (attachment.user != null) {
                    // empty if block
                }
                str.append(attachment.filename);
                AttachmentResourceReference attachmentResourceReference = new AttachmentResourceReference(str.toString());
                if (confluenceReference.getAnchor() != null) {
                    attachmentResourceReference.setAnchor(confluenceReference.getAnchor());
                }
                resourceReference = attachmentResourceReference;
            } else if (confluenceReference.getUser() != null) {
                UserResourceReference userResourceReference = new UserResourceReference(confluenceReference.getUser());
                if (confluenceReference.getAnchor() != null) {
                    userResourceReference.setAnchor(confluenceReference.getAnchor());
                }
                resourceReference = userResourceReference;
            }
            if (resourceReference != null) {
                this.getListener().beginLink(resourceReference, false, Collections.emptyMap());
                if (reference.getLabel() != null) {
                    try {
                        WikiModelParserUtils parserUtils = new WikiModelParserUtils();
                        parserUtils.parseInline(this.plainParser, reference.getLabel(), this.getListener(), false);
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                this.getListener().endLink((ResourceReference)resourceReference, false, Collections.emptyMap());
            }
        } else {
            super.onReference(reference);
        }
    }

    public void onImage(WikiReference reference) {
        if (reference instanceof ConfluenceImageWikiReference) {
            ConfluenceImageWikiReference confluenceReference = (ConfluenceImageWikiReference)reference;
            ResourceReference resourceReference = null;
            if (confluenceReference.getAttachment() != null) {
                AttachmentTagHandler.ConfluenceAttachment attachment = confluenceReference.getAttachment();
                StringBuilder str = new StringBuilder();
                if (attachment.space != null) {
                    str.append(attachment.space);
                    str.append('.');
                }
                if (attachment.page != null) {
                    str.append(attachment.page);
                    str.append('@');
                } else if (attachment.space != null) {
                    str.append("WebHome");
                    str.append('@');
                }
                if (attachment.user != null) {
                    // empty if block
                }
                str.append(attachment.filename);
                resourceReference = new AttachmentResourceReference(str.toString());
            } else if (confluenceReference.getURL() != null) {
                resourceReference = new ResourceReference(confluenceReference.getURL(), ResourceType.URL);
            }
            if (resourceReference != null) {
                this.onImage(resourceReference, false, Collections.emptyMap());
            }
        } else {
            super.onImage(reference);
        }
    }
}

