/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.parser.docbook;

import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.parser.doxia.AbstractDoxiaParser;
import org.xwiki.rendering.syntax.Syntax;

/**
 * DocBook Parser.
 *
 * @version $Id: 490a6a2156cde3fc1a78db00ea22bb386cda0908 $
 * @since 4.1M1
 */
@Component
@Named("docbook/4.4")
@Singleton
public class DocBookParser extends AbstractDoxiaParser
{
    @Override
    public Syntax getSyntax()
    {
        return Syntax.DOCBOOK_4_4;
    }

    @Override
    public org.apache.maven.doxia.parser.Parser createDoxiaParser()
    {
        return new org.apache.maven.doxia.module.docbook.DocBookParser();
    }
}
