/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.renderer.docbook;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.renderer.AbstractBlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;

/**
 * Output DocBook syntax using Doxia's DocBook Sink.
 *
 * @version $Id: 0c813c577e4c304bc094db76dcfd3de108f63d08 $
 * @since 3.2RC1
 */
@Component
@Named("docbook/4.4")
@Singleton
public class DocBookBlockRenderer extends AbstractBlockRenderer
{
    /**
     * Create DocBook Renderer instances.
     */
    @Inject
    @Named("docbook/4.4")
    private PrintRendererFactory docbookRendererFactory;

    @Override
    protected PrintRendererFactory getPrintRendererFactory()
    {
        return this.docbookRendererFactory;
    }
}
