/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.doxia;

import java.io.Reader;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.XDOMGeneratorListener;
import org.xwiki.rendering.internal.parser.doxia.XWikiGeneratorSink;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.util.IdGenerator;

public abstract class AbstractDoxiaParser
implements org.xwiki.rendering.parser.Parser,
StreamParser {
    @Inject
    @Named(value="plain/1.0")
    protected PrintRendererFactory plainRendererFactory;
    @Inject
    @Named(value="plain/1.0")
    private StreamParser plainParser;
    @Inject
    @Named(value="default/link")
    private ResourceReferenceParser linkReferenceParser;
    @Inject
    @Named(value="default/image")
    private ResourceReferenceParser imageReferenceParser;

    public abstract Parser createDoxiaParser();

    public XDOM parse(Reader source) throws ParseException {
        IdGenerator idGenerator = new IdGenerator();
        XDOMGeneratorListener listener = new XDOMGeneratorListener();
        this.parse(source, (Listener)listener, idGenerator);
        XDOM xdom = listener.getXDOM();
        xdom.setIdGenerator(idGenerator);
        return xdom;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        IdGenerator idGenerator = new IdGenerator();
        this.parse(source, listener, idGenerator);
    }

    private void parse(Reader source, Listener listener, IdGenerator idGenerator) throws ParseException {
        XWikiGeneratorSink doxiaSink = new XWikiGeneratorSink(listener, this.linkReferenceParser, this.plainRendererFactory, idGenerator, this.plainParser, this.getSyntax());
        Parser parser = this.createDoxiaParser();
        try {
            parser.parse(source, (Sink)doxiaSink);
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse input source", (Throwable)e);
        }
    }
}

