/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.html5;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLChainingRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.chaining.ListenerChain;

public class HTML5ChainingRenderer
extends XHTMLChainingRenderer {
    private static final String ELEM_SPAN = "span";
    private static final String ELEM_PRE = "pre";
    private static final String PROP_CLASS = "class";

    public HTML5ChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        super(linkRenderer, imageRenderer, listenerChain);
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        if (format == Format.MONOSPACE) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.putAll(parameters);
            String cssClass = "monospace";
            if (attributes.containsKey(PROP_CLASS)) {
                cssClass = String.format("%s %s", cssClass, attributes.get(PROP_CLASS));
            }
            attributes.put(PROP_CLASS, cssClass);
            this.getXHTMLWikiPrinter().printXMLStartElement(ELEM_SPAN, attributes);
        } else {
            super.beginFormat(format, parameters);
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            this.getXHTMLWikiPrinter().printXMLEndElement(ELEM_SPAN);
        }
        if (format == Format.MONOSPACE) {
            if (parameters.isEmpty()) {
                this.getXHTMLWikiPrinter().printXMLEndElement(ELEM_SPAN);
            }
        } else {
            super.endFormat(format, new HashMap());
        }
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        if (inline) {
            this.getXHTMLWikiPrinter().printXMLStartElement(ELEM_SPAN, (String[][])new String[][]{{PROP_CLASS, "wikimodel-verbatim"}});
            this.getXHTMLWikiPrinter().printXML(content);
            this.getXHTMLWikiPrinter().printXMLEndElement(ELEM_SPAN);
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement(ELEM_PRE, parameters);
            this.getXHTMLWikiPrinter().printXML(content);
            this.getXHTMLWikiPrinter().printXMLEndElement(ELEM_PRE);
        }
    }
}

