/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown;

import java.io.IOException;
import java.io.Reader;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SuperNode;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.parser.markdown.PegdownVisitor;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="markdown/1.0")
public class MarkdownStreamParser
implements StreamParser {
    @Inject
    private PegdownVisitor pegdownVisitor;

    public Syntax getSyntax() {
        return Syntax.MARKDOWN_1_0;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        PegDownProcessor processor = new PegDownProcessor(65527);
        try {
            RootNode rootNode = processor.parseMarkdown(IOUtils.toString((Reader)source).toCharArray());
            this.pegdownVisitor.visit((SuperNode)rootNode, listener);
        }
        catch (IOException e) {
            throw new ParseException("Failed to retrieve ", (Throwable)e);
        }
    }
}

