/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.pegdown.ast.Node;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.xwiki.rendering.internal.parser.markdown.AbstractListPegdownVisitor;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractTablePegdownVisitor
extends AbstractListPegdownVisitor {
    private static final String ALIGN_ATTRIBUTE = "align";
    private Stack<Boolean> isInTableHeaderStack = new Stack();
    private Stack<TableNode> currentTableStack = new Stack();
    private Stack<Integer> currentTableColumnPositionStack = new Stack();

    public void visit(TableBodyNode tableBodyNode) {
        this.isInTableHeaderStack.push(false);
        this.visitChildren((Node)tableBodyNode);
        this.isInTableHeaderStack.pop();
    }

    public void visit(TableCellNode tableCellNode) {
        boolean isInHeader = this.isInTableHeaderStack.peek();
        List columns = this.currentTableStack.peek().getColumns();
        TableColumnNode column = (TableColumnNode)columns.get(Math.min(this.currentTableColumnPositionStack.peek(), columns.size() - 1));
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (tableCellNode.getColSpan() > 1) {
            parameters.put("colspan", "" + tableCellNode.getColSpan());
        }
        switch (column.getAlignment()) {
            case Left: {
                parameters.put(ALIGN_ATTRIBUTE, "left");
                break;
            }
            case Right: {
                parameters.put(ALIGN_ATTRIBUTE, "right");
                break;
            }
            case Center: {
                parameters.put(ALIGN_ATTRIBUTE, "center");
                break;
            }
        }
        if (isInHeader) {
            this.getListener().beginTableHeadCell(parameters);
        } else {
            this.getListener().beginTableCell(parameters);
        }
        this.visitChildren((Node)tableCellNode);
        if (isInHeader) {
            this.getListener().endTableHeadCell(parameters);
        } else {
            this.getListener().endTableCell(parameters);
        }
        int currentTableColumn = this.currentTableColumnPositionStack.pop();
        this.currentTableColumnPositionStack.push(currentTableColumn + tableCellNode.getColSpan());
    }

    public void visit(TableColumnNode tableColumnNode) {
    }

    public void visit(TableHeaderNode tableHeaderNode) {
        this.isInTableHeaderStack.push(true);
        this.visitChildren((Node)tableHeaderNode);
        this.isInTableHeaderStack.pop();
    }

    public void visit(TableNode tableNode) {
        this.currentTableStack.push(tableNode);
        this.getListener().beginTable(Collections.EMPTY_MAP);
        this.visitChildren((Node)tableNode);
        this.getListener().endTable(Collections.EMPTY_MAP);
        this.currentTableStack.pop();
    }

    public void visit(TableRowNode tableRowNode) {
        this.currentTableColumnPositionStack.push(0);
        this.getListener().beginTableRow(Collections.EMPTY_MAP);
        this.visitChildren((Node)tableRowNode);
        this.getListener().endTableRow(Collections.EMPTY_MAP);
        this.currentTableColumnPositionStack.pop();
    }

    public void visit(TableCaptionNode tableCaptionNode) {
        String captionText = this.extractText((Node)tableCaptionNode);
        this.getListener().onRawText(String.format("<caption>%s</caption>", captionText), Syntax.HTML_4_01);
    }
}

