/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import javax.inject.Inject;
import javax.inject.Named;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.Visitor;
import org.xwiki.rendering.internal.parser.markdown.PegdownVisitor;
import org.xwiki.rendering.internal.parser.markdown.SectionListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractPegdownVisitor
implements PegdownVisitor {
    @Inject
    @Named(value="plain/1.0")
    protected PrintRendererFactory plainRendererFactory;
    @Inject
    @Named(value="plain/1.0")
    protected StreamParser plainTextStreamParser;
    protected Deque<Listener> listeners = new ArrayDeque<Listener>();

    protected Listener getListener() {
        return this.listeners.peek();
    }

    @Override
    public void visit(SuperNode superNode, Listener listener) {
        SectionListener sectionListener = new SectionListener();
        sectionListener.setWrappedListener(listener);
        this.listeners.push((Listener)sectionListener);
        MetaData metaData = new MetaData(Collections.singletonMap("syntax", Syntax.MARKDOWN_1_0));
        this.getListener().beginDocument(metaData);
        superNode.accept((Visitor)this);
        this.getListener().endDocument(metaData);
    }

    public void visit(RootNode rootNode) {
        for (ReferenceNode ref : rootNode.getReferences()) {
            this.visit(ref);
        }
        for (AbbreviationNode abbr : rootNode.getAbbreviations()) {
            this.visit(abbr);
        }
        this.visitChildren((Node)rootNode);
    }

    protected void visitChildren(Node node) {
        for (Node child : node.getChildren()) {
            child.accept((Visitor)this);
        }
    }

    public void visit(Node node) {
    }

    public void visit(SuperNode superNode) {
        this.visitChildren((Node)superNode);
    }

    protected String extractText(Node node) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.listeners.push((Listener)this.plainRendererFactory.createRenderer((WikiPrinter)printer));
        this.visitChildren(node);
        this.listeners.pop();
        return printer.toString();
    }
}

