/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.plain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="plain/1.0")
@Singleton
public class PlainTextStreamParser
implements StreamParser {
    public static final Pattern SPECIALSYMBOL_PATTERN = Pattern.compile("[!\"#$%&'()*+,-./:;<=>?@\\[\\]^_`{|}~]");

    public Syntax getSyntax() {
        return Syntax.PLAIN_1_0;
    }

    private int readChar(Reader source) throws ParseException {
        int c;
        try {
            c = source.read();
        }
        catch (IOException e) {
            throw new ParseException("Failed to read input source", (Throwable)e);
        }
        return c;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        int charAsInt;
        StringBuilder word = new StringBuilder();
        BufferedReader bufferedSource = new BufferedReader(source);
        listener.beginDocument(MetaData.EMPTY);
        boolean paragraphSent = false;
        while ((charAsInt = this.readChar(bufferedSource)) != -1) {
            if (!paragraphSent) {
                listener.beginParagraph(Listener.EMPTY_PARAMETERS);
                paragraphSent = true;
            }
            this.parseChar(charAsInt, word, listener);
        }
        if (word.length() > 0) {
            listener.onWord(word.toString());
        }
        if (paragraphSent) {
            listener.endParagraph(Listener.EMPTY_PARAMETERS);
        }
        listener.endDocument(MetaData.EMPTY);
    }

    private void parseChar(int charAsInt, StringBuilder word, Listener listener) throws ParseException {
        char c = (char)charAsInt;
        if (c == '\n') {
            if (word.length() > 0) {
                listener.onWord(word.toString());
            }
            listener.onNewLine();
            word.setLength(0);
        } else if (c != '\r') {
            if (c == ' ') {
                if (word.length() > 0) {
                    listener.onWord(word.toString());
                }
                listener.onSpace();
                word.setLength(0);
            } else if (SPECIALSYMBOL_PATTERN.matcher(String.valueOf(c)).matches()) {
                if (word.length() > 0) {
                    listener.onWord(word.toString());
                }
                listener.onSpecialSymbol(c);
                word.setLength(0);
            } else {
                word.append(c);
            }
        }
    }
}

