/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.tex;

import java.util.Map;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.internal.renderer.wikimodel.WikiModelGeneratorListener;
import org.xwiki.rendering.internal.renderer.wikimodel.WikiModelPrinterAdapter;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.tex.TexSerializer;

@Component
@Named(value="tex/1.0")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class TexRenderer
extends WrappingListener
implements PrintRenderer {
    private WikiPrinter printer;

    public WikiPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(WikiPrinter printer) {
        this.printer = printer;
        this.setWrappedListener((Listener)new WikiModelGeneratorListener((IWemListener)new TexSerializer((IWikiPrinter)new WikiModelPrinterAdapter(this.getPrinter()), null, null, null)));
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.printer.print("\\textbf{");
                break;
            }
            case ITALIC: {
                this.printer.print("\\textit{");
                break;
            }
            case MONOSPACE: {
                this.printer.print("\\texttt{");
                break;
            }
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: 
            case ITALIC: 
            case MONOSPACE: {
                this.printer.print("}");
                break;
            }
        }
    }
}

