/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.VelocityFilter;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component(value="list")
public class ListSyntaxFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern LISTYNTAX_PATTERN = Pattern.compile("(?:^" + VelocityFilter.SPACEGROUP_OC_SPATTERN + "([-#*]++|[-#*iIaA1ghHkKj]++\\.)[\\p{Blank}]++[^\r\n]++([ \t]*+[\r\n]++)*+)++", 8);
    private static final Pattern LISTITEMSYNTAX_PATTERN = Pattern.compile("^(" + VelocityFilter.SPACEGROUP_OC_SPATTERN + ")([-#*]++|[-#*iIaA1ghHkKj]++\\.)([\\p{Blank}]++[^\r\n]++)([ \t]*+[\r\n]++)*+", 8);

    public void initialize() throws InitializationException {
        this.setPriority(900);
    }

    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = LISTYNTAX_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = content.substring(currentIndex, matcher.start());
            if (currentIndex > 0) {
                before = CleanUtil.setTrailingNewLines(CleanUtil.setLeadingNewLines(before, 2), 2);
            }
            result.append(before);
            result.append(this.filterList(matcher.group(0), filterContext));
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(CleanUtil.setLeadingNewLines(content.substring(currentIndex), 2));
        return result.toString();
    }

    public String filterList(String content, FilterContext filterContext) {
        StringBuffer listResult = new StringBuffer();
        Matcher matcher = LISTITEMSYNTAX_PATTERN.matcher(content);
        int currentIndex = 0;
        char currentListSign = '\u0000';
        while (matcher.find()) {
            String listString;
            String before = content.substring(currentIndex, matcher.start());
            if (currentIndex > 0) {
                before = CleanUtil.setLeadingNewLines(before, 1);
            }
            StringBuffer listItemResult = new StringBuffer();
            String listSigns = matcher.group(2);
            char listSign = listSigns.charAt(0);
            String listStyle = "";
            if (listSign == '#') {
                listString = StringUtils.repeat((String)"1", (int)listSigns.length()) + ".";
            } else if (listSign == '1') {
                listString = listSigns;
            } else if (listSign == '-') {
                listStyle = "square";
                listString = StringUtils.repeat((String)"*", (int)listSigns.length());
            } else if (listSign == 'a') {
                listStyle = "lower-alpha";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'A') {
                listStyle = "upper-alpha";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'i') {
                listStyle = "lower-roman";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'I') {
                listStyle = "upper-roman";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'g') {
                listStyle = "lower-greek";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'h') {
                listStyle = "hiragana";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'H') {
                listStyle = "hiragana-iroha";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'k') {
                listStyle = "katakana";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'K') {
                listStyle = "katakana-iroha";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == 'j') {
                listStyle = "hebrew";
                listString = StringUtils.repeat((String)"*", (int)(listSigns.length() - 1));
            } else if (listSign == '*') {
                listString = listSigns;
            } else {
                this.getLogger().error("Unknown list sign: " + listSign);
                listString = StringUtils.repeat((String)"*", (int)listSigns.length());
            }
            if (listSign != currentListSign) {
                if (currentListSign != '\u0000' && currentIndex > 0) {
                    before = CleanUtil.setTrailingNewLines(before, 2);
                }
                if (listStyle.length() > 0) {
                    listItemResult.append(filterContext.addProtectedContent(MessageFormat.format("(% style=\"list-style-type: {0}\" %)\n", listStyle), false));
                }
            }
            listItemResult.append(filterContext.addProtectedContent(matcher.group(1) + listString, false));
            listItemResult.append(matcher.group(3));
            listResult.append(before);
            listResult.append(listItemResult);
            currentListSign = listSign;
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        listResult.append(content.substring(currentIndex));
        return CleanUtil.extractVelocity(listResult, filterContext);
    }
}

