/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.HTMLFilter;
import org.xwiki.rendering.internal.parser.xwiki10.VelocityFilter;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;

@Component(value="unescapehtml")
public class UnescapeHTMLFilter
extends AbstractFilter
implements Initializable {
    public static final Pattern HTMLVELOCITY_SPATTERN = Pattern.compile("(" + VelocityFilter.VELOCITYOPEN_SPATTERN + ")|(" + VelocityFilter.VELOCITYCLOSE_PATTERN + ")|(" + HTMLFilter.HTMLOPEN_SPATTERN + ")|(" + HTMLFilter.HTMLCLOSE_SPATTERN + ")");

    public void initialize() throws InitializationException {
        this.setPriority(3001);
    }

    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = HTMLVELOCITY_SPATTERN.matcher(content);
        boolean inHTML = false;
        int currentIndex = 0;
        while (matcher.find()) {
            String before = content.substring(currentIndex, matcher.start());
            if (!inHTML) {
                result.append(this.unescapeNonHtmlContent(before));
            } else {
                result.append(before);
            }
            inHTML = matcher.group(1) != null || matcher.group(3) != null;
            result.append(matcher.group());
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return this.unescapeNonHtmlContent(content);
        }
        result.append(this.unescapeNonHtmlContent(content.substring(currentIndex)));
        return result.toString();
    }

    private String unescapeNonHtmlContent(String content) {
        return StringEscapeUtils.unescapeHtml((String)content);
    }
}

