/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component(value="pre")
public class PreFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern PRE_PATTERN = Pattern.compile("\\{pre\\}(.*?)\\{/pre\\}", 34);
    @Requirement(value="spacescleanning")
    public Filter spacesCleaningFilter;
    @Requirement(value="standalonenewlinecleanning")
    public Filter standaloneNewLineCleaningFilter;

    public void initialize() throws InitializationException {
        this.setPriority(100);
    }

    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = PRE_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = content.substring(currentIndex, matcher.start());
            result.append(before);
            StringBuffer preBuffer = new StringBuffer();
            preBuffer.append("{{{");
            String preContent = matcher.group(1);
            preContent = this.standaloneNewLineCleaningFilter.filter(preContent, filterContext);
            preContent = this.spacesCleaningFilter.filter(preContent, filterContext);
            preBuffer.append(preContent.trim());
            preBuffer.append("}}}");
            result.append(CleanUtil.extractVelocity(preBuffer, filterContext, true, true));
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(content.substring(currentIndex));
        return result.toString();
    }
}

