/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;

@Component(value="standalonenewlinecleanning")
public class StandaloneNewLineCleaningFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern SANDALONENEWLINE_PATTERN = Pattern.compile("([^\\n])\\n([^\\n])", 8);

    public void initialize() throws InitializationException {
        this.setPriority(4000);
    }

    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = FilterContext.XWIKI1020TOKENS_PATTERN.matcher(content);
        int current = 0;
        while (matcher.find()) {
            String before = content.substring(current, matcher.start());
            result.append(SANDALONENEWLINE_PATTERN.matcher(before).replaceAll("$1 $2"));
            result.append(matcher.group(0));
            current = matcher.end();
        }
        result.append(SANDALONENEWLINE_PATTERN.matcher(content.substring(current)).replaceAll("$1 $2"));
        return result.toString();
    }
}

