/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.parser.xwiki10.macro;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.VelocityMacroConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVelocityMacroConverter
implements VelocityMacroConverter {
    private String name;
    private List<String> parameterNameList = new ArrayList<String>();

    protected AbstractVelocityMacroConverter() {
    }

    protected AbstractVelocityMacroConverter(String name) {
        this.name = name;
    }

    protected void addParameterName(String parameterName) {
        this.parameterNameList.add(parameterName);
    }

    @Override
    public boolean protectResult() {
        return true;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    protected String convertName(String name) {
        return this.name == null ? name : this.name;
    }

    protected Map<String, String> convertParameters(List<String> parameters) {
        LinkedHashMap<String, String> parameters20 = new LinkedHashMap<String, String>(parameters.size());
        for (int index = 0; index < parameters.size(); ++index) {
            this.convertParameter(parameters20, index, parameters.get(index));
        }
        return parameters20;
    }

    protected void convertParameter(Map<String, String> parameters20, int index, String value) {
        String key;
        if (this.parameterNameList.size() > index && (key = this.parameterNameList.get(index)) != null) {
            parameters20.put(this.parameterNameList.get(index), value);
        }
    }

    protected String convertContent(List<String> parameters, FilterContext context) {
        return null;
    }

    protected String cleanQuotes(String value) {
        String cleaned = value;
        if (!StringUtils.isEmpty((String)cleaned)) {
            char firstChar = value.charAt(0);
            char lastChar = value.charAt(value.length() - 1);
            if ((firstChar == '\"' || firstChar == '\'') && firstChar == lastChar) {
                cleaned = cleaned.substring(1, cleaned.length() - 1);
            }
        }
        return cleaned;
    }

    @Override
    public String convert(String name, List<String> parameters, FilterContext context) {
        StringBuffer begin = new StringBuffer();
        String content = this.convertContent(parameters, context);
        Map<String, String> params = this.convertParameters(parameters);
        begin.append("{{");
        begin.append(this.convertName(name));
        if (params.size() > 0) {
            begin.append(' ');
            this.appendParameters(begin, params);
        }
        StringBuffer result = new StringBuffer();
        if (content != null) {
            begin.append("}}");
            result.append(!this.protectResult() ? context.addProtectedContent(begin.toString(), this.isInline()) : begin);
            result.append(content);
            StringBuffer end = new StringBuffer();
            end.append("{{/");
            end.append(this.convertName(name));
            end.append("}}");
            result.append(!this.protectResult() ? context.addProtectedContent(end.toString(), this.isInline()) : end);
        } else {
            begin.append("/");
            begin.append("}}");
            result.append(!this.protectResult() ? context.addProtectedContent(begin.toString(), this.isInline()) : begin);
        }
        return result.toString();
    }

    protected void appendParameters(StringBuffer result, Map<String, String> parameters) {
        StringBuffer parametersSB = new StringBuffer();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (parametersSB.length() > 0) {
                parametersSB.append(" ");
            }
            parametersSB.append(parameter.getKey());
            parametersSB.append("=");
            parametersSB.append(parameter.getValue());
        }
        result.append(parametersSB);
    }
}

