/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="url")
@Singleton
public class UrlFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern URL_PATTERN = Pattern.compile("(?<![\"'=])((?:ht|f)tps?)://((?:%[\\p{Digit}A-Fa-f][\\p{Digit}A-Fa-f]|[-_.!~*';/?:@#&=+$,\\p{Alnum}])++)(?!['\">])");

    public void initialize() throws InitializationException {
        this.setPriority(1000);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = URL_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = content.substring(currentIndex, matcher.start());
            result.append(CleanUtil.removeTrailingNewLines(before, 1, true));
            result.append(filterContext.addProtectedContent(matcher.group(0), true));
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(content.substring(currentIndex));
        return result.toString();
    }
}

