/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.EscapeFilter;
import org.xwiki.rendering.internal.parser.xwiki10.RadeoxMacrosFilter;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="code")
@Singleton
public class CodeMacroFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern CODEMACRO_PATTERN = Pattern.compile("\\{(code)(?::([^\\}]*))?\\}(.*?)\\{code\\}", 32);
    @Inject
    @Named(value="code")
    private RadeoxMacroConverter codeMacroConverter;
    @Inject
    @Named(value="unescape")
    private Filter unescapeFilter;
    private EscapeFilter escapeFilter = new EscapeFilter();

    public void initialize() throws InitializationException {
        this.setPriority(10);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        String escapedContent = this.escapeFilter.filter(content, filterContext, false);
        Matcher matcher = CODEMACRO_PATTERN.matcher(escapedContent);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = escapedContent.substring(currentIndex, matcher.start());
            if (result.length() > 0) {
                before = CleanUtil.setLeadingNewLines(before, 2);
            }
            before = CleanUtil.setTrailingNewLines(before, 2);
            String macroResult = this.codeMacroConverter.convert("code", RadeoxMacrosFilter.getMacroParameters(this.codeMacroConverter, matcher.group(2)), matcher.group(3), filterContext);
            result.append(before);
            result.append(filterContext.addProtectedContent(macroResult, false));
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(CleanUtil.setLeadingNewLines(escapedContent.substring(currentIndex), 2));
        return this.unescapeFilter.filter(result.toString(), filterContext);
    }
}

