/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10.macro;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.AbstractRadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="quote")
@Singleton
public class QuoteRadeoxMacroConverter
extends AbstractRadeoxMacroConverter {
    @Inject
    @Named(value="standalonenewlinecleanning")
    private Filter standaloneNewLineCleaningFilter;

    public QuoteRadeoxMacroConverter() {
        this.registerParameter("");
    }

    @Override
    public String convert(String name, RadeoxMacroParameters parameters, String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((CharSequence)content.replaceAll("[ \t]", ""))) {
            result.append(">");
            result.append(CleanUtil.removeTrailingNewLines(CleanUtil.removeLeadingNewLines(this.standaloneNewLineCleaningFilter.filter(content, filterContext))).replaceAll("\n", "\n>"));
        }
        return result.toString();
    }

    @Override
    public boolean supportContent() {
        return true;
    }

    @Override
    public boolean isInline() {
        return false;
    }
}

