/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.velocity.ExtendedVelocityParser;
import org.xwiki.rendering.internal.parser.xwiki10.velocity.ExtendedVelocityParserContext;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;
import org.xwiki.velocity.internal.util.InvalidVelocityException;
import org.xwiki.velocity.internal.util.VelocityBlock;

@Component
@Named(value="velocity")
@Singleton
public class VelocityFilter
extends AbstractFilter
implements Initializable {
    public static final String VELOCITY_SF = "velocity";
    public static final String VELOCITYNOOUTPUT_SF = "velocitynooutput";
    public static final String VELOCITYOPEN_SF = "velocityopen";
    public static final String VELOCITYCLOSE_SF = "velocityclose";
    public static final String VELOCITYCOMMENT_SF = "velocitynooutput" + VelocityBlock.VelocityType.COMMENT;
    public static final String VELOCITY_SPATTERN = "(?:" + FilterContext.XWIKI1020TOKEN_OP + "(?:XWIKI1020TOKEN[IS])" + "velocity" + "\\p{L}*\\d+" + FilterContext.XWIKI1020TOKEN_CP + ")";
    public static final String VELOCITYOPEN_SPATTERN = "(?:" + FilterContext.XWIKI1020TOKEN_OP + "(?:XWIKI1020TOKENI)" + "velocityopen" + "\\d+" + FilterContext.XWIKI1020TOKEN_CP + ")";
    public static final String VELOCITYCLOSE_SPATTERN = "(?:" + FilterContext.XWIKI1020TOKEN_OP + "(?:XWIKI1020TOKENI)" + "velocityclose" + "\\d+" + FilterContext.XWIKI1020TOKEN_CP + ")";
    public static final String VELOCITYNOOUTPUT_SPATTERN = "(?:" + FilterContext.XWIKI1020TOKEN_OP + "(?:XWIKI1020TOKEN[IS])" + "velocitynooutput" + "\\p{L}*\\d+" + FilterContext.XWIKI1020TOKEN_CP + ")";
    public static final String VELOCITYCONTENT_SPATTERN = "(?:" + VELOCITYOPEN_SPATTERN + ".*" + VELOCITYCLOSE_SPATTERN + ")";
    public static final String NLGROUP_SPATTERN = "(?:(?:\n|" + VELOCITYNOOUTPUT_SPATTERN + ")*)";
    public static final String SPACEGROUP_SPATTERN = "(?:(?:[ \\t]|" + VELOCITYNOOUTPUT_SPATTERN + ")*)";
    public static final String EMPTY_OC_SPATTERN = VELOCITYOPEN_SPATTERN + "?" + VELOCITYNOOUTPUT_SPATTERN + "*" + VELOCITYCLOSE_SPATTERN + "?";
    public static final String SPACEGROUP_OC_SPATTERN = "[ \\t]*" + VELOCITYOPEN_SPATTERN + "?" + SPACEGROUP_SPATTERN + VELOCITYCLOSE_SPATTERN + "?" + "[ \\t]*";
    public static final Pattern VELOCITYOPEN_PATTERN = Pattern.compile(VELOCITYOPEN_SPATTERN);
    public static final Pattern VELOCITYCLOSE_PATTERN = Pattern.compile(VELOCITYCLOSE_SPATTERN);
    public static final Pattern VELOCITYCONTENT_PATTERN = Pattern.compile(VELOCITYCONTENT_SPATTERN, 32);
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private ExtendedVelocityParser velocityParser;

    public void initialize() throws InitializationException {
        this.setPriority(20);
        this.velocityParser = new ExtendedVelocityParser(this.componentManager);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        char[] array = content.toCharArray();
        ExtendedVelocityParserContext context = new ExtendedVelocityParserContext(filterContext);
        StringBuffer beforeVelocityBuffer = new StringBuffer();
        StringBuffer velocityBuffer = new StringBuffer();
        StringBuffer afterVelocityBuffer = new StringBuffer();
        boolean inVelocityMacro = false;
        int i = 0;
        StringBuffer velocityBlock = new StringBuffer();
        while (i < array.length) {
            StringBuffer nonVelocityBuffer;
            char c = array[i];
            context.setVelocity(false);
            context.setConversion(false);
            context.setInline(true);
            context.setProtectedBlock(true);
            context.setType(null);
            velocityBlock.setLength(0);
            try {
                if (c == '#') {
                    i = this.velocityParser.getKeyWord(array, i, velocityBlock, context);
                } else if (c == '$') {
                    i = this.velocityParser.getVar(array, i, velocityBlock, context);
                } else if (c == '\\' && array.length > i + 1) {
                    char escapedChar = array[i + 1];
                    if (escapedChar == '\\') {
                        c = escapedChar;
                        ++i;
                    } else {
                        int newI = i + 1;
                        if (escapedChar == '#') {
                            newI = this.velocityParser.getKeyWord(array, newI, velocityBlock, context);
                        } else if (escapedChar == '$') {
                            newI = this.velocityParser.getVar(array, newI, velocityBlock, context);
                        }
                        if (context.isVelocity() && context.getType() != VelocityBlock.VelocityType.COMMENT || context.isConversion()) {
                            c = escapedChar;
                            ++i;
                        }
                        context.setVelocity(false);
                        context.setConversion(false);
                        context.setInline(true);
                        context.setProtectedBlock(true);
                        context.setType(null);
                    }
                }
            }
            catch (InvalidVelocityException e) {
                this.logger.debug("Not a valid Velocity block at char [" + i + "]", (Throwable)e);
                context.setVelocity(false);
            }
            if (context.isVelocity()) {
                if (!inVelocityMacro) {
                    inVelocityMacro = true;
                } else {
                    velocityBuffer.append(afterVelocityBuffer);
                    afterVelocityBuffer.setLength(0);
                }
                if (context.isConversion() && !context.isInline() && velocityBuffer.length() > 0) {
                    CleanUtil.setTrailingNewLines(velocityBuffer, 2);
                }
                velocityBuffer.append(context.isProtectedBlock() ? filterContext.addProtectedContent(velocityBlock.toString(), (velocityBlock.charAt(velocityBlock.length() - 1) == '\n' ? VELOCITYNOOUTPUT_SF : VELOCITY_SF) + context.getType(), context.isInline()) : velocityBlock);
                continue;
            }
            StringBuffer stringBuffer = nonVelocityBuffer = inVelocityMacro ? afterVelocityBuffer : beforeVelocityBuffer;
            if (context.isConversion()) {
                if (!(context.isInline() || nonVelocityBuffer.length() <= 0 && velocityBuffer.length() <= 0)) {
                    CleanUtil.setTrailingNewLines(nonVelocityBuffer, 2);
                }
                nonVelocityBuffer.append(context.isProtectedBlock() ? filterContext.addProtectedContent(velocityBlock.toString(), context.isInline()) : velocityBlock);
                continue;
            }
            nonVelocityBuffer.append(c);
            ++i;
        }
        if (context.isInVelocityBlock()) {
            velocityBuffer.append(afterVelocityBuffer);
            afterVelocityBuffer.setLength(0);
            while (context.isInVelocityBlock()) {
                velocityBuffer.append(filterContext.addProtectedContent("#end\n", VELOCITYNOOUTPUT_SF, true));
                context.popVelocityElement();
            }
        }
        if (velocityBuffer.length() > 0) {
            String beforeVelocityContent = beforeVelocityBuffer.toString();
            String velocityContent = velocityBuffer.toString();
            String unProtectedVelocityContent = filterContext.unProtect(velocityContent);
            String afterVelocityContent = afterVelocityBuffer.toString();
            boolean multilines = unProtectedVelocityContent.indexOf("\n") != -1;
            result.append(beforeVelocityContent);
            VelocityFilter.appendVelocityOpen(result, filterContext, multilines);
            result.append(velocityContent);
            VelocityFilter.appendVelocityClose(result, filterContext, multilines);
            result.append(afterVelocityContent);
        } else {
            result = beforeVelocityBuffer;
        }
        return result.toString();
    }

    public static void appendVelocityOpen(StringBuffer result, FilterContext filterContext, boolean nl) {
        result.append(filterContext.addProtectedContent("{{velocity filter=\"none\"}}" + (nl ? "\n" : ""), VELOCITYOPEN_SF, true));
    }

    public static void appendVelocityClose(StringBuffer result, FilterContext filterContext, boolean nl) {
        result.append(filterContext.addProtectedContent((nl ? "\n" : "") + "{{/velocity}}", VELOCITYCLOSE_SF, true));
    }
}

