/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10.macro;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.AbstractRadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;

@Component
@Named(value="image")
@Singleton
public class ImageRadeoxMacroConverter
extends AbstractRadeoxMacroConverter {
    public ImageRadeoxMacroConverter() {
        this.registerParameter("");
        this.registerParameter("height", 3);
        this.registerParameter("width", 3);
        this.registerParameter("align", 3);
        this.registerParameter("halign", 1);
        this.registerParameter("document", 2);
        this.registerParameter("alt");
        this.registerParameter("title");
        this.registerParameter("link");
        this.registerParameter("fromIncludingDoc");
    }

    @Override
    public String convert(String name, RadeoxMacroParameters parameters, String content, FilterContext filterContext) {
        RadeoxMacroParameter link;
        StringBuffer result = new StringBuffer();
        Map<String, String> parametersClone = this.convertParameters(parameters);
        RadeoxMacroParameter img = (RadeoxMacroParameter)parameters.get("");
        if (null == img || img.getValue().indexOf("=") != -1 && img.getValue().indexOf("://") == -1) {
            return "";
        }
        RadeoxMacroParameter alt = (RadeoxMacroParameter)parameters.get("alt");
        RadeoxMacroParameter title = (RadeoxMacroParameter)parameters.get("title");
        if (alt == null && title != null) {
            alt = title;
            parametersClone.put(title.getName(), title.getValue());
        } else if (alt != null && title == null) {
            title = alt;
            parametersClone.put(alt.getName(), alt.getValue());
        } else {
            alt = title = img;
        }
        parametersClone.put(alt.getName(), alt.getValue());
        parametersClone.put(title.getName(), title.getValue());
        RadeoxMacroParameter halign = (RadeoxMacroParameter)parameters.get("halign");
        if (halign != null) {
            result.append("(% class=\"img" + halign.getValue().trim() + "\" %)");
            result.append("(((");
            parametersClone.remove("halign");
        }
        if ((link = (RadeoxMacroParameter)parameters.get("link")) != null && link.getValue().indexOf("=") == -1 && !link.getValue().toLowerCase().startsWith("f")) {
            result.append("[[");
            parametersClone.remove("link");
        }
        result.append("[[");
        if (parameters.size() == 1 || parameters.size() == 2 && parameters.containsKey("document")) {
            this.appendSimpleImage(result, parameters);
        } else {
            this.appendSimpleImage(result, parameters);
            parametersClone.remove("");
            parametersClone.remove("document");
            result.append("||");
            this.appendParameters(result, parametersClone);
        }
        result.append("]]");
        if (link != null && link.getValue().indexOf("=") == -1 && !link.getValue().toLowerCase().startsWith("f")) {
            result.append(">>attach:");
            this.appendAttachmentReference(result, parameters);
            result.append("]]");
        }
        if (halign != null) {
            result.append(")))");
        }
        return result.toString();
    }

    private void appendSimpleImage(StringBuffer result, RadeoxMacroParameters parameters) {
        result.append("image:");
        this.appendAttachmentReference(result, parameters);
    }

    private void appendAttachmentReference(StringBuffer result, RadeoxMacroParameters parameters) {
        RadeoxMacroParameter document = (RadeoxMacroParameter)parameters.get("document");
        if (document != null) {
            result.append(document.getValue());
            result.append("@");
        }
        result.append(parameters.get(""));
    }

    @Override
    public boolean supportContent() {
        return false;
    }
}

