/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki20;

import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.test.AbstractComponentTestCase;

public class XWiki20ImageReferenceParserTest
extends AbstractComponentTestCase {
    private ResourceReferenceParser parser;

    protected void registerComponents() throws Exception {
        this.registerMockComponent(WikiModel.class);
        this.parser = (ResourceReferenceParser)this.getComponentManager().getInstance(ResourceReferenceParser.class, "xwiki/2.0/image");
    }

    @Test
    public void testParseImagesCommon() throws Exception {
        ResourceReference reference = this.parser.parse("wiki:space.page@filename");
        Assert.assertEquals((Object)ResourceType.ATTACHMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"wiki:space.page@filename", (Object)reference.getReference());
        Assert.assertEquals((Object)"Typed = [false] Type = [attach] Reference = [wiki:space.page@filename]", (Object)reference.toString());
        Assert.assertFalse((boolean)reference.isTyped());
        reference = this.parser.parse("http://server/path/to/image");
        Assert.assertEquals((Object)ResourceType.URL, (Object)reference.getType());
        Assert.assertEquals((Object)"http://server/path/to/image", (Object)reference.getReference());
        Assert.assertEquals((Object)"Typed = [false] Type = [url] Reference = [http://server/path/to/image]", (Object)reference.toString());
        Assert.assertFalse((boolean)reference.isTyped());
    }

    @Test
    public void testParseImages() throws Exception {
        ResourceReference reference = this.parser.parse("attach:wiki:space.page@filename");
        Assert.assertEquals((Object)ResourceType.ATTACHMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"attach:wiki:space.page@filename", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)"Typed = [false] Type = [attach] Reference = [attach:wiki:space.page@filename]", (Object)reference.toString());
    }
}

