/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.test.cts.TestDataConfiguration;
import org.xwiki.text.XWikiToStringBuilder;

public class TestData {
    public String syntaxId;
    public String prefix;
    public String syntaxExtension;
    public String ctsExtension;
    public boolean isSyntaxInputTest;
    public String ctsData;
    public String syntaxData;
    public TestDataConfiguration configuration;

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("syntaxId", (Object)this.syntaxId).append("prefix", (Object)this.prefix).append("syntaxExtension", (Object)this.syntaxExtension).append("ctsExtension", (Object)this.ctsExtension).append("isSyntaxInputTest", this.isSyntaxInputTest).append("ctsData", (Object)this.ctsData).append("syntaxData", (Object)this.syntaxData).append("configuration", (Object)this.configuration).toString();
    }

    public boolean isNotApplicable() {
        return this.matches(this.configuration.notApplicableTests);
    }

    public boolean isFailingTest() {
        return this.matches(this.configuration.failingTests);
    }

    private boolean matches(List<String> regexes) {
        boolean matches = false;
        for (String regex : regexes) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(this.computeTestName());
            if (!matcher.matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public String computeTestName() {
        return String.format("%s [%s, %s:%s, CTS:%s]", this.prefix, this.syntaxId, this.isSyntaxInputTest ? "IN" : "OUT", this.syntaxExtension, this.ctsExtension);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TestData)) {
            return false;
        }
        TestData rhs = (TestData)object;
        return new EqualsBuilder().append((Object)this.syntaxId, (Object)rhs.syntaxId).append((Object)this.prefix, (Object)rhs.prefix).append((Object)this.syntaxExtension, (Object)rhs.syntaxExtension).append((Object)this.ctsExtension, (Object)rhs.ctsExtension).append(this.isSyntaxInputTest, rhs.isSyntaxInputTest).append((Object)this.ctsData, (Object)rhs.ctsData).append((Object)this.syntaxData, (Object)rhs.syntaxData).append((Object)this.configuration, (Object)rhs.configuration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 17).append((Object)this.syntaxId).append((Object)this.prefix).append((Object)this.syntaxExtension).append((Object)this.ctsExtension).append(this.isSyntaxInputTest).append((Object)this.ctsData).append((Object)this.syntaxData).append((Object)this.configuration).toHashCode();
    }
}

