/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.rendering.test.integration.TestData;
import org.xwiki.rendering.test.integration.TestDataParser;

public class TestDataGenerator {
    private TestDataParser parser = new TestDataParser();

    public Collection<Object[]> generateData(String testPackage, String pattern) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(ClasspathHelper.forPackage((String)"", (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder.Include(Pattern.quote(testPackage) + ".*")));
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String testResourceName : reflections.getResources(Pattern.compile(pattern))) {
            data.addAll(this.parseSingleResource(testResourceName));
        }
        return data;
    }

    private Collection<Object[]> parseSingleResource(String testResourceName) {
        TestData data;
        String resourceName = "/" + testResourceName;
        try {
            InputStream source = this.getClass().getResourceAsStream(resourceName);
            if (source == null) {
                throw new RuntimeException("Failed to find test file [" + resourceName + "]");
            }
            data = this.parser.parse(source, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read test data from [" + resourceName + "]", e);
        }
        boolean hasEventOutput = false;
        int inputCounter = 0;
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : data.inputs.entrySet()) {
            ++inputCounter;
            for (String targetSyntaxId : data.expectations.keySet()) {
                String parserId = entry.getKey();
                String input = entry.getValue();
                if ("xhtml/1.0".equals(parserId) && !input.startsWith("<?xml") && !input.startsWith("<!DOCTYPE")) {
                    input = this.normalizeHTML(input);
                } else if ("docbook/4.4".equals(parserId) && !input.startsWith("<?xml") && !input.startsWith("<!DOCTYPE")) {
                    input = this.normalizeDocBook(input);
                }
                if (inputCounter >= 2 && hasEventOutput && !"event/1.0".equals(targetSyntaxId)) continue;
                Object[] singleResult = new Object[8];
                singleResult[0] = this.computeTestName(testResourceName, parserId, targetSyntaxId);
                singleResult[1] = input;
                String expected = data.expectations.get(targetSyntaxId);
                if ("docbook/4.4".equals(targetSyntaxId) && !expected.startsWith("<?xml") && !expected.startsWith("<!DOCTYPE")) {
                    expected = this.normalizeDocBook(expected);
                }
                singleResult[2] = expected;
                singleResult[3] = parserId;
                singleResult[4] = targetSyntaxId;
                singleResult[5] = data.streaming;
                singleResult[6] = data.transformations;
                singleResult[7] = data.configuration;
                result.add(singleResult);
                if (!"event/1.0".equals(targetSyntaxId)) continue;
                hasEventOutput = true;
            }
        }
        return result;
    }

    private String normalizeHTML(String content) {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html>" + content + "</html>";
    }

    private String normalizeDocBook(String content) {
        return "<?xml version=\"1.0\"?><!DOCTYPE article PUBLIC \"-//OASIS//DTD Simplified DocBook XML V1.1//EN\" \"http://www.oasis-open.org/docbook/xml/simple/1.1/sdocbook.dtd\">" + content;
    }

    private String computeTestName(String prefix, String parserId, String targetSyntaxId) {
        return prefix + " [" + parserId + ", " + targetSyntaxId + "]";
    }
}

