/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.test.integration.TestData;

public class TestDataParser {
    private static final String TRANSFORMATION_PREFIX = ".runTransformations";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData parse(InputStream source, String resourceName) throws IOException {
        TestData data = new TestData();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source, "UTF-8"));){
            String line;
            String action = null;
            String keyName = null;
            boolean skip = false;
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(".")) {
                    StringTokenizer st;
                    if (line.startsWith(".#")) continue;
                    if (line.startsWith(".streaming")) {
                        data.streaming = true;
                        continue;
                    }
                    if (line.startsWith(TRANSFORMATION_PREFIX)) {
                        data.transformations = this.parseTransformationDirective(line);
                        continue;
                    }
                    if (line.startsWith(".configuration")) {
                        st = new StringTokenizer(line.substring(".configuration".length() + 1), "=");
                        data.configuration.put(st.nextToken(), st.nextToken());
                        continue;
                    }
                    if (!skip) {
                        this.saveData(action, buffer, data, keyName);
                    }
                    buffer.setLength(0);
                    st = new StringTokenizer(line.substring(1), "|");
                    action = st.nextToken();
                    keyName = st.nextToken();
                    skip = false;
                    if (!st.hasMoreTokens()) continue;
                    skip = true;
                    System.out.println("[WARNING] Skipping test for [" + keyName + "] in resource [" + resourceName + "] since it has been marked as skipped in the test. This needs to be reviewed and fixed.");
                    continue;
                }
                buffer.append(line).append('\n');
            }
            if (!skip) {
                this.saveData(action, buffer, data, keyName);
            }
        }
        return data;
    }

    private List<String> parseTransformationDirective(String line) {
        if (line.length() > TRANSFORMATION_PREFIX.length() + 1 && line.charAt(TRANSFORMATION_PREFIX.length()) == ':') {
            return Arrays.asList(StringUtils.split((String)line.substring(TRANSFORMATION_PREFIX.length() + 1), (String)","));
        }
        return Collections.emptyList();
    }

    private void saveData(String action, StringBuffer buffer, TestData data, String keyName) {
        if (action != null) {
            if ("input".equalsIgnoreCase(action)) {
                this.saveBuffer(buffer, data.inputs, keyName);
            } else if ("expect".equalsIgnoreCase(action)) {
                this.saveBuffer(buffer, data.expectations, keyName);
            } else if ("inputexpect".equalsIgnoreCase(action)) {
                this.saveBuffer(buffer, data.inputs, keyName);
                this.saveBuffer(buffer, data.expectations, keyName);
            }
        }
    }

    private void saveBuffer(StringBuffer buffer, Map<String, String> map, String keyName) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.setLength(buffer.length() - 1);
        }
        map.put(keyName, buffer.toString());
    }
}

