/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.test.cts.TestData;

public class RenderingTest {
    private static final String CTS_SYNTAX_ID = Syntax.XDOMXML_CURRENT.toIdString();
    private static final VelocityEngine VELOCITY_ENGINE = new VelocityEngine();
    private TestData testData;
    private ComponentManager componentManager;
    private Syntax metadataSyntax;

    public RenderingTest(TestData testData, String metadataSyntaxId, ComponentManager componentManager) {
        this.testData = testData;
        this.componentManager = componentManager;
        this.metadataSyntax = this.parseSyntax(metadataSyntaxId);
    }

    @Test
    public void execute() throws Exception {
        if (this.testData.isSyntaxInputTest) {
            this.executeInputTest();
        } else {
            this.executeOutputTest();
        }
    }

    private void executeInputTest() throws Exception {
        this.executeTest(this.testData.syntaxData, this.testData.syntaxId, this.testData.ctsData, CTS_SYNTAX_ID);
    }

    private void executeOutputTest() throws Exception {
        this.executeTest(this.testData.ctsData, CTS_SYNTAX_ID, this.testData.syntaxData, this.testData.syntaxId);
    }

    private void executeTest(String inputData, String inputSyntaxId, String expectedOutputData, String outputSyntaxId) throws Exception {
        String evaluatedInputData = this.evaluateContent(inputData);
        String evaluatedOutputData = this.evaluateContent(expectedOutputData);
        Parser parser = (Parser)this.getComponentManager().getInstance(Parser.class, inputSyntaxId);
        XDOM xdom = parser.parse((Reader)new StringReader(evaluatedInputData));
        BlockRenderer renderer = (BlockRenderer)this.getComponentManager().getInstance(BlockRenderer.class, outputSyntaxId);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.render((Block)xdom, (WikiPrinter)printer);
        String result = printer.toString();
        try {
            if (this.isXMLSyntax(outputSyntaxId)) {
                this.assertExpectedResult(this.normalizeXMLContent(evaluatedOutputData, outputSyntaxId), result);
            } else {
                this.assertExpectedResult(evaluatedOutputData, result);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Failed to compare expected result with [%s]", result), e);
        }
    }

    private boolean isXMLSyntax(String syntaxId) {
        return syntaxId.startsWith("xdom+xml") || syntaxId.startsWith("docbook");
    }

    private String normalizeXMLContent(String content, String syntaxId) throws Exception {
        Parser parser = (Parser)this.getComponentManager().getInstance(Parser.class, syntaxId);
        XDOM xdom = parser.parse((Reader)new StringReader(content));
        BlockRenderer renderer = (BlockRenderer)this.getComponentManager().getInstance(BlockRenderer.class, syntaxId);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.render((Block)xdom, (WikiPrinter)printer);
        return printer.toString();
    }

    private String evaluateContent(String content) {
        VelocityContext context = new VelocityContext();
        context.put("syntax", (Object)this.metadataSyntax);
        StringWriter writer = new StringWriter();
        VELOCITY_ENGINE.evaluate((Context)context, (Writer)writer, "Rendering CTS", content);
        return writer.toString();
    }

    private void assertExpectedResult(String expected, String result) {
        String escapedExpected = this.escapeRegexContent(expected);
        Pattern pattern = Pattern.compile(escapedExpected, 32);
        Matcher matcher = pattern.matcher(result);
        if (!matcher.matches()) {
            throw new ComparisonFailure("", expected, result);
        }
    }

    private String escapeRegexContent(String content) {
        StringBuilder builder = new StringBuilder();
        int pos = content.indexOf("${{{regex:");
        if (pos > -1) {
            builder.append(Pattern.quote(content.substring(0, pos)));
            int pos2 = content.indexOf("}}}", pos + 10);
            if (pos2 == -1) {
                throw new RuntimeException("Invalid regex declaration: missing closing part }}}");
            }
            builder.append(content.substring(pos + 10, pos2));
            builder.append(this.escapeRegexContent(content.substring(pos2 + 3)));
        } else {
            builder.append(Pattern.quote(content));
        }
        return builder.toString();
    }

    private ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private Syntax parseSyntax(String syntaxId) {
        try {
            SyntaxFactory factory = (SyntaxFactory)this.getComponentManager().getInstance(SyntaxFactory.class);
            return factory.createSyntaxFromIdString(syntaxId);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to parse Syntax [%s]", syntaxId), e);
        }
    }
}

