/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.xwiki.rendering.test.cts.Initialized;
import org.xwiki.rendering.test.cts.TestData;
import org.xwiki.test.XWikiComponentInitializer;

public class RenderingTestClassRunner
extends BlockJUnit4ClassRunner {
    private XWikiComponentInitializer componentInitializer = new XWikiComponentInitializer();
    private Object testInstance;
    private TestData testData;
    private String metadataSyntaxId;

    RenderingTestClassRunner(Object testInstance, Class<?> testClass, TestData testData, String metadataSyntaxId) throws InitializationError {
        super(testClass);
        this.testInstance = testInstance;
        this.testData = testData;
        this.metadataSyntaxId = metadataSyntaxId;
    }

    public Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.testData, this.metadataSyntaxId, this.componentInitializer.getComponentManager());
    }

    protected String getName() {
        return this.testData.computeTestName();
    }

    protected String testName(FrameworkMethod method) {
        return this.getName();
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        try {
            this.componentInitializer.initializeConfigurationSource();
            this.componentInitializer.initializeExecution();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Component Manager", e);
        }
        try {
            for (Method klassMethod : this.testInstance.getClass().getMethods()) {
                Initialized componentManagerAnnotation = klassMethod.getAnnotation(Initialized.class);
                if (componentManagerAnnotation == null) continue;
                klassMethod.invoke(this.testInstance, this.componentInitializer.getComponentManager());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call Component Manager initialization method", e);
        }
        try {
            super.runChild(method, notifier);
        }
        finally {
            try {
                this.componentInitializer.shutdown();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to shutdown Component Manager", e);
            }
        }
    }
}

