/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.rendering.test.cts.TestData;
import org.xwiki.rendering.test.cts.TestDataConfiguration;

public class TestDataParser {
    private static final String SLASH = "/";
    private static final String DOT = ".";

    public List<TestData> parseTestData(String syntaxId, String ctsRootPackageName, String packageFilter, String pattern) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ArrayList<TestData> data = new ArrayList<TestData>();
        String syntaxDirectory = this.computeSyntaxDirectory(syntaxId);
        TestDataConfiguration configuration = this.parseTestConfiguration(syntaxDirectory, ctsRootPackageName, classLoader);
        Set<String> relativeDirectoryNames = this.findRelativeTestDirectoryNames(ctsRootPackageName, packageFilter, pattern);
        for (String relativeDirectoryName : relativeDirectoryNames) {
            List<TestData> testDatas = this.parseSingleTestData(syntaxDirectory, ctsRootPackageName, relativeDirectoryName, configuration, classLoader);
            for (TestData testData : testDatas) {
                testData.syntaxId = syntaxId;
                testData.prefix = relativeDirectoryName;
                testData.configuration = configuration;
                data.add(testData);
            }
        }
        return data;
    }

    public List<TestData> parseSingleTestData(String syntaxDirectory, String ctsRootPackageName, String relativeDirectoryName, TestDataConfiguration configuration, ClassLoader classLoader) throws IOException {
        TestData testDataIN = new TestData();
        testDataIN.isSyntaxInputTest = true;
        TestData testDataOUT = new TestData();
        Pair<Pair<String, String>, Pair<String, String>> ctsData = this.readDataForPrefix(ctsRootPackageName + SLASH + relativeDirectoryName, "xml", classLoader);
        Pair<Pair<String, String>, Pair<String, String>> syntaxData = this.readDataForPrefix(syntaxDirectory + SLASH + relativeDirectoryName, configuration.fileExtension, classLoader);
        testDataIN.syntaxData = (String)((Pair)syntaxData.getLeft()).getLeft();
        testDataIN.syntaxExtension = (String)((Pair)syntaxData.getLeft()).getRight();
        testDataIN.ctsData = (String)((Pair)ctsData.getRight()).getLeft();
        testDataIN.ctsExtension = (String)((Pair)ctsData.getRight()).getRight();
        testDataOUT.syntaxData = (String)((Pair)syntaxData.getRight()).getLeft();
        testDataOUT.syntaxExtension = (String)((Pair)syntaxData.getRight()).getRight();
        testDataOUT.ctsData = (String)((Pair)ctsData.getLeft()).getLeft();
        testDataOUT.ctsExtension = (String)((Pair)ctsData.getLeft()).getRight();
        List<TestData> testDataINAliases = this.parseAliasesTestData(syntaxDirectory, relativeDirectoryName, ctsData, configuration, classLoader);
        if (configuration.inheritSyntax != null) {
            Pair<Pair<String, String>, Pair<String, String>> inheritedSyntaxData = this.readDataForPrefix(this.computeSyntaxDirectory(configuration.inheritSyntax) + SLASH + relativeDirectoryName, configuration.fileExtension, classLoader);
            if (testDataIN.syntaxData == null) {
                testDataIN.syntaxData = (String)((Pair)inheritedSyntaxData.getLeft()).getLeft();
                testDataIN.syntaxExtension = (String)((Pair)inheritedSyntaxData.getLeft()).getRight();
            }
            if (testDataOUT.syntaxData == null) {
                testDataOUT.syntaxData = (String)((Pair)inheritedSyntaxData.getRight()).getLeft();
                testDataOUT.syntaxExtension = (String)((Pair)inheritedSyntaxData.getRight()).getRight();
            }
        }
        ArrayList<TestData> result = new ArrayList<TestData>();
        result.add(testDataIN);
        result.addAll(testDataINAliases);
        result.add(testDataOUT);
        return result;
    }

    private List<TestData> parseAliasesTestData(String syntaxDirectory, String relativeDirectoryName, Pair<Pair<String, String>, Pair<String, String>> ctsData, TestDataConfiguration configuration, ClassLoader classLoader) throws IOException {
        Pair<Pair<String, String>, Pair<String, String>> syntaxDataAlias;
        ArrayList<TestData> testDataINAliases = new ArrayList<TestData>();
        int i = 1;
        do {
            if (((Pair)(syntaxDataAlias = this.readDataForPrefix(syntaxDirectory + SLASH + relativeDirectoryName, i + DOT + configuration.fileExtension, classLoader)).getLeft()).getLeft() != null) {
                TestData testDataINAlias = new TestData();
                testDataINAlias.isSyntaxInputTest = true;
                testDataINAlias.syntaxData = (String)((Pair)syntaxDataAlias.getLeft()).getLeft();
                testDataINAlias.syntaxExtension = (String)((Pair)syntaxDataAlias.getLeft()).getRight();
                testDataINAlias.ctsData = (String)((Pair)ctsData.getRight()).getLeft();
                testDataINAlias.ctsExtension = (String)((Pair)ctsData.getRight()).getRight();
                testDataINAliases.add(testDataINAlias);
            }
            ++i;
        } while (((Pair)syntaxDataAlias.getLeft()).getLeft() != null);
        return testDataINAliases;
    }

    public TestDataConfiguration parseTestConfiguration(String syntaxDirectory, String ctsRootPackageName, ClassLoader classLoader) throws Exception {
        TestDataConfiguration configuration = new TestDataConfiguration();
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        this.addConfigurationData(compositeConfiguration, ctsRootPackageName, classLoader);
        this.addConfigurationData(compositeConfiguration, syntaxDirectory, classLoader);
        configuration.notApplicableTests = compositeConfiguration.getList("notApplicableTests", Collections.emptyList());
        configuration.failingTests = compositeConfiguration.getList("failingTests", Collections.emptyList());
        configuration.testDescriptions = compositeConfiguration.getProperties("testDescriptions", new Properties());
        configuration.inheritSyntax = compositeConfiguration.getString("inheritSyntax");
        configuration.fileExtension = compositeConfiguration.getString("fileExtension", "txt");
        return configuration;
    }

    private void addConfigurationData(CompositeConfiguration configuration, String rootPackageName, ClassLoader classLoader) throws Exception {
        URL configurationURL = classLoader.getResource(rootPackageName + "/config.properties");
        if (configurationURL != null) {
            configuration.addConfiguration((org.apache.commons.configuration.Configuration)new PropertiesConfiguration(configurationURL));
        }
    }

    private Pair<Pair<String, String>, Pair<String, String>> readDataForPrefix(String prefix, String fileExtension, ClassLoader classLoader) throws IOException {
        String out;
        String in;
        String inExtension;
        String outExtension = inExtension = ".inout." + fileExtension;
        String inOut = this.readData(prefix + inExtension, classLoader);
        if (inOut == null) {
            inExtension = ".in." + fileExtension;
            outExtension = ".out." + fileExtension;
            in = this.readData(prefix + inExtension, classLoader);
            out = this.readData(prefix + outExtension, classLoader);
        } else {
            in = inOut;
            out = inOut;
        }
        return new ImmutablePair((Object)new ImmutablePair((Object)in, (Object)inExtension), (Object)new ImmutablePair((Object)out, (Object)outExtension));
    }

    private String readData(String resourceName, ClassLoader classLoader) throws IOException {
        String input = null;
        URL inputURL = classLoader.getResource(resourceName);
        if (inputURL != null) {
            input = IOUtils.toString((URL)inputURL);
        }
        return input;
    }

    public Set<String> findRelativeTestDirectoryNames(String ctsRootPackageName, String packageFilter, String pattern) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(ClasspathHelper.forPackage((String)ctsRootPackageName, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)(ctsRootPackageName + DOT + packageFilter)))));
        TreeSet<String> prefixes = new TreeSet<String>();
        for (String fullTestDirectoryName : reflections.getResources(Pattern.compile(pattern))) {
            String testDirectoryName = StringUtils.substringAfter((String)fullTestDirectoryName, (String)(ctsRootPackageName + SLASH));
            testDirectoryName = StringUtils.substringBeforeLast((String)testDirectoryName, (String)".inout.xml");
            prefixes.add(testDirectoryName);
        }
        return prefixes;
    }

    private String computeSyntaxDirectory(String syntaxId) {
        return syntaxId.replace(SLASH, "").replace(DOT, "");
    }
}

